/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeSavanna;
import rtg.world.gen.surface.vanilla.SurfaceVanillaSavannaM;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaSavannaM;

public class RealisticBiomeVanillaSavannaM
extends RealisticBiomeVanillaBase {
    public static BiomeGenBase standardBiome = BiomeGenBase.field_150588_X;
    public static BiomeGenBase mutationBiome = BiomeGenBase.func_150568_d((int)(RealisticBiomeVanillaSavannaM.standardBiome.field_76756_M + 128));
    public static Block topBlock = RealisticBiomeVanillaSavannaM.mutationBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeVanillaSavannaM.mutationBiome.field_76753_B;

    public RealisticBiomeVanillaSavannaM() {
        super(mutationBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainVanillaSavannaM(), new SurfaceVanillaSavannaM(topBlock, fillerBlock));
        this.setRealisticBiomeName("Vanilla Savanna M");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaSavannaM;
        this.generateVillages = ConfigVanilla.villageVanillaSavannaM;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        for (int i23 = 0; i23 < 1; ++i23) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(8) != 0) continue;
            new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        float l = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        if (l > 0.0f && rand.nextInt(12) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(Blocks.field_150363_s, 0, (Block)Blocks.field_150361_u, -1, 3 + rand.nextInt(3)).func_76484_a(world, rand, x22, y22, z22);
        }
        if (river > 0.8f) {
            int b33 = 0;
            while ((float)b33 < 15.0f * strength) {
                int j6 = chunkX + rand.nextInt(16) + 8;
                int k10 = chunkY + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10);
                Object worldgenerator = rand.nextInt(3) != 0 ? new WorldGenShrub(0, 0) : (rand.nextInt(9) == 0 ? new WorldGenTreeSavanna(1) : new WorldGenTreeSavanna(2));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                ++b33;
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
        }
        for (int f23 = 0; f23 < 3; ++f23) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
        }
        for (int l14 = 0; l14 < 20; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(3) == 0) {
                new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
        }
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
    }
}

