/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.surface.vanilla.SurfaceVanillaMegaSpruceTaiga;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaMegaSpruceTaiga;

public class RealisticBiomeVanillaMegaSpruceTaiga
extends RealisticBiomeVanillaBase {
    public static BiomeGenBase standardBiome = BiomeGenBase.field_150578_U;
    public static BiomeGenBase mutationBiome = BiomeGenBase.func_150568_d((int)(RealisticBiomeVanillaMegaSpruceTaiga.standardBiome.field_76756_M + 128));
    public static Block topBlock = RealisticBiomeVanillaMegaSpruceTaiga.mutationBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeVanillaMegaSpruceTaiga.mutationBiome.field_76753_B;

    public RealisticBiomeVanillaMegaSpruceTaiga() {
        super(mutationBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.COLD), (TerrainBase)new TerrainVanillaMegaSpruceTaiga(), new SurfaceVanillaMegaSpruceTaiga(topBlock, fillerBlock));
        this.setRealisticBiomeName("Vanilla Mega Spruce Taiga");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaMegaSpruceTaiga;
        this.generateVillages = ConfigVanilla.villageVanillaMegaSpruceTaiga;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        float l = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        if (l > 0.0f && rand.nextInt(6) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
    }
}

