/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.RandomUtil;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenJungleCacti;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeMangrove;
import rtg.world.gen.feature.tree.WorldGenTreePalmCustom;
import rtg.world.gen.surface.vanilla.SurfaceVanillaJungleM;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaJungleM;

public class RealisticBiomeVanillaJungleM
extends RealisticBiomeVanillaBase {
    public static BiomeGenBase standardBiome = BiomeGenBase.field_76782_w;
    public static BiomeGenBase mutationBiome = BiomeGenBase.func_150568_d((int)(RealisticBiomeVanillaJungleM.standardBiome.field_76756_M + 128));
    public static Block topBlock = RealisticBiomeVanillaJungleM.mutationBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeVanillaJungleM.mutationBiome.field_76753_B;

    public RealisticBiomeVanillaJungleM() {
        super(mutationBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.WET), (TerrainBase)new TerrainVanillaJungleM(), new SurfaceVanillaJungleM(topBlock, fillerBlock));
        this.setRealisticBiomeName("Vanilla Jungle M");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaJungleM;
        this.generateVillages = ConfigVanilla.villageVanillaJungleM;
        this.waterSurfaceLakeChance = 3;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int z52;
        int k10;
        int j6;
        int b33;
        float l = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f + 0.8f;
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            for (b33 = 0; b33 < 5; ++b33) {
                WorldGenTreePalmCustom worldgenerator;
                int z521;
                int k101;
                j6 = chunkX + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 100 && rand.nextBoolean()) {
                    Object worldgenerator2 = rand.nextInt(3) != 0 ? new WorldGenMegaJungle(false, 10 + rand.nextInt(18), 20, 3, 3) : new WorldGenTreeMangrove(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, 3, 10 + rand.nextInt(18), 3 + rand.nextInt(2), 13.0f, RandomUtil.getRandomInt(rand, 4, 5), 0.32f, 0.2f);
                    worldgenerator2.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator2.func_76484_a(world, rand, j6, z52, k10);
                }
                if (rand.nextInt(3) == 0) {
                    int j61 = chunkX + rand.nextInt(16) + 8;
                    k101 = chunkY + rand.nextInt(16) + 8;
                    z521 = world.func_72976_f(j61, k101);
                    worldgenerator = new WorldGenTreePalmCustom(10 + rand.nextInt(11));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j61, z521, k101);
                }
                if (rand.nextInt(3) != 0) continue;
                int j61 = chunkX + rand.nextInt(16) + 8;
                k101 = chunkY + rand.nextInt(16) + 8;
                z521 = world.func_72976_f(j61, k101);
                worldgenerator = new WorldGenMegaJungle(false, 20 + rand.nextInt(20), 0, 3, 3);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j61, z521, k101);
            }
            if (l > 0.0f && rand.nextInt(3) == 0) {
                int x22 = chunkX + rand.nextInt(16) + 8;
                int z22 = chunkY + rand.nextInt(16) + 8;
                int y22 = world.func_72976_f(x22, z22);
                new WorldGenLog(Blocks.field_150364_r, 3, (Block)Blocks.field_150362_t, -1, 4 + rand.nextInt(5)).func_76484_a(world, rand, x22, y22, z22);
            }
        }
        if (rand.nextInt(4) != 0) {
            RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            for (b33 = 0; b33 < 5; ++b33) {
                int h44;
                j6 = chunkX + rand.nextInt(16) + 8;
                k10 = chunkY + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10);
                for (h44 = 0; h44 < 8; ++h44) {
                    if (z52 <= 64) continue;
                    WorldGenWaterlily worldgenerator2 = new WorldGenWaterlily();
                    worldgenerator2.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator2.func_76484_a(world, rand, j6, z52, k10);
                }
                for (h44 = 0; h44 < 50; ++h44) {
                    WorldGenVines worldgenerator4 = new WorldGenVines();
                    worldgenerator4.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator4.func_76484_a(world, rand, j6, z52, k10);
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            int j24;
            int k22;
            int l19;
            int l14 = 0;
            while ((float)l14 < 16.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                j24 = chunkY + rand.nextInt(16) + 8;
                int grassMeta = rand.nextInt(8) == 0 ? 0 : RandomUtil.getRandomInt(rand, 1, 2);
                new WorldGenGrass((Block)Blocks.field_150329_H, grassMeta).func_76484_a(world, rand, l19, k22, j24);
                for (int h44 = 0; h44 < 4 && k22 > 63; ++h44) {
                    WorldGenVines worldgenerator4 = new WorldGenVines();
                    worldgenerator4.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator4.func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
            l14 = 0;
            while ((float)l14 < 12.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(5) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, RandomUtil.getRandomInt(rand, 2, 3)).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
            l14 = 0;
            while ((float)l14 < 16.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                j24 = chunkY + rand.nextInt(16) + 8;
                int grassMeta = rand.nextInt(8) == 0 ? 0 : RandomUtil.getRandomInt(rand, 1, 2);
                new WorldGenGrass((Block)Blocks.field_150329_H, grassMeta).func_76484_a(world, rand, l19, k22, j24);
                if (k22 > 63) {
                    for (int h44 = 0; h44 < 8; ++h44) {
                        WorldGenVines worldgenerator4 = new WorldGenVines();
                        worldgenerator4.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator4.func_76484_a(world, rand, l19, k22, j24);
                    }
                }
                ++l14;
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            int f23 = 0;
            while ((float)f23 < 2.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j20 = chunkY + rand.nextInt(16) + 8;
                int j17 = world.func_72976_f(j15, j20);
                if (rand.nextInt(4) == 0) {
                    new WorldGenFlowers(new int[]{5}).func_76484_a(world, rand, j15, j17, j20);
                }
                ++f23;
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            int k18 = 0;
            while ((float)k18 < 8.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenJungleCacti(false, rand.nextInt(7), 1).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
        }
        int l1 = 0;
        while ((float)l1 < 2.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && rand.nextInt(16) == 0) {
                new WorldGenBlob(Blocks.field_150341_Y, 0, rand).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l1;
        }
    }
}

