/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreePine;
import rtg.world.gen.feature.tree.WorldGenTreePineSmall;
import rtg.world.gen.surface.vanilla.SurfaceVanillaIceMountains;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaIceMountains;

public class RealisticBiomeVanillaIceMountains
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_76775_o.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_76775_o.field_76753_B;

    public RealisticBiomeVanillaIceMountains() {
        super(BiomeGenBase.field_76775_o, BiomeBase.climatizedBiome(BiomeGenBase.field_76777_m, BiomeBase.Climate.ICE), (TerrainBase)new TerrainVanillaIceMountains(230.0f, 80.0f, 0.0f), new SurfaceVanillaIceMountains(topBlock, fillerBlock, Blocks.field_150433_aE, Blocks.field_150433_aE, Blocks.field_150403_cj, Blocks.field_150432_aD, 60.0f, -0.14f, 14.0f, 0.25f));
        this.setRealisticBiomeName("Vanilla Ice Mountains");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaIceMountains;
        this.generateVillages = ConfigVanilla.villageVanillaIceMountains;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int z22;
        int x22;
        int y22;
        int l = 0;
        while ((float)l < 6.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && rand.nextInt(16) == 0) {
                new WorldGenBlob(Blocks.field_150347_e, 0, rand).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        float l2 = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 12.0f + 4.0f;
        int b1 = 0;
        while ((float)b1 < l2 * strength) {
            WorldGenTreePineSmall worldgenerator;
            int k10;
            int j6 = chunkX + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
            if (z52 < 90) {
                worldgenerator = rand.nextInt(8) != 0 ? new WorldGenTreePine(4, rand.nextInt(4) == 0 ? 1 : 0) : (rand.nextInt(3) != 0 ? new WorldGenTreePineSmall(3 + rand.nextInt(6), 6 + rand.nextInt(8), 0) : new WorldGenIceSpike());
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            } else if (z52 < 120) {
                worldgenerator = rand.nextInt(4) != 0 ? new WorldGenTreePineSmall(1 + rand.nextInt(3), 3 + rand.nextInt(5), rand.nextInt(2)) : new WorldGenIceSpike();
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            ++b1;
        }
        if (rand.nextInt((int)(12.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
    }
}

