/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreePineEuro;
import rtg.world.gen.surface.vanilla.SurfaceVanillaExtremeHillsPlus;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaExtremeHillsPlus;

public class RealisticBiomeVanillaExtremeHillsPlus
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_150580_W.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_150580_W.field_76753_B;

    public RealisticBiomeVanillaExtremeHillsPlus() {
        super(BiomeGenBase.field_150580_W, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.COLD), (TerrainBase)new TerrainVanillaExtremeHillsPlus(230.0f, 120.0f, 0.0f), new SurfaceVanillaExtremeHillsPlus((Block)Blocks.field_150349_c, Blocks.field_150346_d, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150351_n, 0.08f));
        this.setRealisticBiomeName("Vanilla Extreme Hills +");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaExtremeHillsPlus;
        this.generateVillages = ConfigVanilla.villageVanillaExtremeHillsPlus;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int i23;
        int i18;
        int k10;
        int j6;
        for (int i232 = 0; i232 < 1; ++i232) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 >= 80) continue;
            new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        float l = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        if (l > 0.0f && rand.nextInt(6) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreePineEuro();
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                i18 = chunkX + rand.nextInt(16) + 8;
                i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        } else {
            int z52;
            int a = 3 - (int)(simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 10.0f);
            if ((a < 1 || rand.nextInt(a) == 0) && ((float)(z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0)) {
                Object worldgenerator = rand.nextInt(14) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreePineEuro();
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt((int)(3.0f / strength)) == 0) {
                i18 = chunkX + rand.nextInt(16) + 8;
                i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        }
    }
}

