/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenCacti;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.tree.WorldGenTreeSavanna;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceRiverOasis;
import rtg.world.gen.surface.vanilla.SurfaceVanillaDesertHills;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaDesertHills;

public class RealisticBiomeVanillaDesertHills
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_76786_s.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_76786_s.field_76753_B;
    private static SurfaceBase surface = new SurfaceVanillaDesertHills((Block)Blocks.field_150354_m, Blocks.field_150322_A, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f);
    private static SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeVanillaDesertHills() {
        super(BiomeGenBase.field_76786_s, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.OASIS), (TerrainBase)new TerrainVanillaDesertHills(600.0f, 50.0f, 0.0f), surface);
        this.setRealisticBiomeName("Vanilla Desert Hills");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaDesertHills;
        this.generateVillages = ConfigVanilla.villageVanillaDesertHills;
        this.waterSurfaceLakeChance = 0;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int k24;
        int j23;
        int k21;
        int k18;
        int j1;
        int i1;
        int k1;
        if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85 && rand.nextInt(16) == 0) {
            new WorldGenBlob(Blocks.field_150347_e, 0, rand).func_76484_a(world, rand, i1, k1, j1);
        }
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    int k10;
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreeSavanna(1);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            k18 = 0;
            while ((float)k18 < 12.0f * strength) {
                k21 = chunkX + rand.nextInt(16) + 8;
                j23 = rand.nextInt(160);
                k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            if (rand.nextInt(28) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(128);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(6) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        }
        for (k18 = 0; k18 < 12; ++k18) {
            k21 = chunkX + rand.nextInt(16) + 8;
            j23 = rand.nextInt(160);
            k24 = chunkY + rand.nextInt(16) + 8;
            if (!((float)j23 < 120.0f)) continue;
            new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
        }
        int i15 = 0;
        while ((float)i15 < 3.0f * strength) {
            int i17 = chunkX + rand.nextInt(16) + 8;
            int i20 = rand.nextInt(160);
            int l22 = chunkY + rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            ++i15;
        }
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
    }
}

