/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenCacti;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.tree.WorldGenTreeSavanna;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceRiverOasis;
import rtg.world.gen.surface.vanilla.SurfaceVanillaDesert;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaDesert;

public class RealisticBiomeVanillaDesert
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_76769_d.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_76769_d.field_76753_B;
    private static SurfaceBase surface = new SurfaceVanillaDesert(topBlock, fillerBlock);
    private static SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeVanillaDesert() {
        super(BiomeGenBase.field_76769_d, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.OASIS), (TerrainBase)new TerrainVanillaDesert(), surface);
        this.setRealisticBiomeName("Vanilla Desert");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaDesert;
        this.generateVillages = ConfigVanilla.villageVanillaDesert;
        this.waterSurfaceLakeChance = 0;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int l22;
        int i20;
        int i17;
        int i15;
        int k24;
        int j23;
        int k21;
        int k18;
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    int k10;
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        Object worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : new WorldGenTreeSavanna(1);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            k18 = 0;
            while ((float)k18 < 12.0f * strength) {
                k21 = chunkX + rand.nextInt(16) + 8;
                j23 = rand.nextInt(160);
                k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(6) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
            i15 = 0;
            while ((float)i15 < 1.0f * strength) {
                if (rand.nextInt(100) == 0) {
                    i17 = chunkX + rand.nextInt(16) + 8;
                    i20 = 64 + rand.nextInt(64);
                    l22 = chunkY + rand.nextInt(16) + 8;
                    new WorldGenDesertWells().func_76484_a(world, rand, i17, i20, l22);
                }
                ++i15;
            }
        }
        k18 = 0;
        while ((float)k18 < 5.0f * strength) {
            k21 = chunkX + rand.nextInt(16) + 8;
            j23 = 64 + rand.nextInt(64);
            k24 = chunkY + rand.nextInt(16) + 8;
            if ((float)j23 < 120.0f) {
                new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
            }
            ++k18;
        }
        i15 = 0;
        while ((float)i15 < 1.0f * strength) {
            i17 = chunkX + rand.nextInt(16) + 8;
            i20 = 64 + rand.nextInt(64);
            l22 = chunkY + rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            ++i15;
        }
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
    }
}

