/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreePine;
import rtg.world.gen.feature.tree.WorldGenTreePineSmall;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.feature.tree.WorldGenTreeSpruceSmall;
import rtg.world.gen.surface.vanilla.SurfaceVanillaColdTaigaHills;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaColdTaigaHills;

public class RealisticBiomeVanillaColdTaigaHills
extends RealisticBiomeVanillaBase {
    public static Block topBlock = BiomeGenBase.field_150579_T.field_76752_A;
    public static Block fillerBlock = BiomeGenBase.field_150579_T.field_76753_B;

    public RealisticBiomeVanillaColdTaigaHills() {
        super(BiomeGenBase.field_150579_T, BiomeBase.climatizedBiome(BiomeGenBase.field_76777_m, BiomeBase.Climate.ICE), (TerrainBase)new TerrainVanillaColdTaigaHills(), new SurfaceVanillaColdTaigaHills((Block)Blocks.field_150349_c, Blocks.field_150346_d, true, (Block)Blocks.field_150354_m, 0.2f));
        this.setRealisticBiomeName("Vanilla Cold Taiga Hills");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaColdTaigaHills;
        this.generateVillages = ConfigVanilla.villageVanillaColdTaigaHills;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int z22;
        int x22;
        int y22;
        int l = 0;
        while ((float)l < 6.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && rand.nextInt(16) == 0) {
                new WorldGenBlob(Blocks.field_150341_Y, 0, rand).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        float l2 = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 12.0f + 4.0f;
        int b1 = 0;
        while ((float)b1 < l2 * strength) {
            WorldGenerator worldgenerator;
            int k10;
            int j6 = chunkX + rand.nextInt(16) + 8;
            int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
            if (z52 < 90) {
                worldgenerator = rand.nextInt(10) != 0 ? new WorldGenTreePine(4, rand.nextInt(4) == 0 ? 1 : 0) : (rand.nextInt(3) != 0 ? new WorldGenTreePineSmall(3 + rand.nextInt(6), 6 + rand.nextInt(8), 0) : new WorldGenTreeSpruceSmall(rand.nextInt(2) + 1));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            } else if (z52 < 120) {
                worldgenerator = rand.nextInt(4) != 0 ? new WorldGenTreePineSmall(1 + rand.nextInt(3), 3 + rand.nextInt(5), rand.nextInt(2)) : new WorldGenTreeSpruceSmall(rand.nextInt(2));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            ++b1;
        }
        if (rand.nextInt((int)(4.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int f24 = 0;
        while ((float)f24 < 4.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 110) {
                new WorldGenTreeShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            }
            ++f24;
        }
        if (rand.nextInt((int)(20.0f / strength)) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(100);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }
}

