/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.config.vanilla.ConfigVanilla;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.RandomUtil;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaBase;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeBirch;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.surface.vanilla.SurfaceVanillaBirchForestM;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.vanilla.TerrainVanillaBirchForestM;

public class RealisticBiomeVanillaBirchForestM
extends RealisticBiomeVanillaBase {
    public static BiomeGenBase standardBiome = BiomeGenBase.field_150583_P;
    public static BiomeGenBase mutationBiome = BiomeGenBase.func_150568_d((int)(RealisticBiomeVanillaBirchForestM.standardBiome.field_76756_M + 128));
    public static Block topBlock = RealisticBiomeVanillaBirchForestM.mutationBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeVanillaBirchForestM.mutationBiome.field_76753_B;

    public RealisticBiomeVanillaBirchForestM() {
        super(mutationBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.TEMPERATE), (TerrainBase)new TerrainVanillaBirchForestM(), new SurfaceVanillaBirchForestM(topBlock, fillerBlock, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150346_d, 2, 0.15f));
        this.setRealisticBiomeName("Vanilla Birch Forest M");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigVanilla.weightVanillaBirchForestM;
        this.generateVillages = ConfigVanilla.villageVanillaBirchForestM;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        float l = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            int b2 = 0;
            while ((float)b2 < 16.0f * strength) {
                int j6 = chunkX + rand.nextInt(16) + 8;
                int k10 = chunkY + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10);
                WorldGenTreeBirch worldgenerator = new WorldGenTreeBirch(16 + rand.nextInt(8), rand.nextInt(8) + 4);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                ++b2;
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            int j24;
            int k22;
            int l19;
            int l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                j24 = chunkY + rand.nextInt(16) + 8;
                new WorldGenGrass((Block)Blocks.field_150398_cm, RandomUtil.getRandomInt(rand, 2, 3)).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
            l14 = 0;
            while ((float)l14 < 24.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = rand.nextInt(128);
                j24 = chunkY + rand.nextInt(16) + 8;
                new WorldGenGrass((Block)Blocks.field_150329_H, rand.nextInt(3)).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            int z22;
            int x22;
            int y22;
            if (rand.nextInt((int)(16.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
                new WorldGenLog(Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, -1, 3 + rand.nextInt(4)).func_76484_a(world, rand, x22, y22, z22);
            }
            int f24 = 0;
            while ((float)f24 < 2.0f * strength) {
                int j1;
                int i1 = chunkX + rand.nextInt(16) + 8;
                int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                if (k1 < 110) {
                    new WorldGenTreeShrub(rand.nextInt(4) + 1, 0, rand.nextInt(3)).func_76484_a(world, rand, i1, k1, j1);
                }
                ++f24;
            }
        }
    }
}

