/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.api.HighlandsBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.highlands.ConfigHL;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenVolcano;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceRiverOasis;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPVolcano;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLVolcanoIsland;

public class RealisticBiomeHLVolcanoIsland
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.volcanoIsland;
    private static Block bopTopBlock = Blocks.field_150349_c;
    private static byte bopTopByte = 0;
    private static Block bopFillBlock = Blocks.field_150346_d;
    private static byte bopFillByte = 0;
    private static Block bopMixTopBlock = Blocks.field_150348_b;
    private static byte bopMixTopByte = 0;
    private static Block bopMixFillBlock = Blocks.field_150346_d;
    private static byte bopMixFillByte = 0;
    private static SurfaceBase surface = new SurfaceBOPVolcano(bopTopBlock, bopTopByte, bopFillBlock, bopFillByte, bopMixTopBlock, bopMixTopByte, bopMixFillBlock, bopMixFillByte, 80.0f, -0.15f, 10.0f, 0.5f);
    private static SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeHLVolcanoIsland() {
        super(hlBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainHLVolcanoIsland(), surface);
        this.setRealisticBiomeName("HL Volcano Island");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigHL.weightHLVolcanoIsland;
        this.generateVillages = ConfigHL.villageHLVolcanoIsland;
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 1;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        for (int l14 = 0; l14 < 15; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(3) == 0) {
                new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
        }
    }

    @Override
    public void rMapGen(Block[] blocks, byte[] metadata, World world, WorldChunkManagerRTG cmr, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        float river;
        if (baseX % 4 == 0 && baseY % 4 == 0 && mapRand.nextInt(6) == 0 && (river = cmr.getRiverStrength(baseX * 16, baseY * 16) + 1.0f) > 0.98f && cmr.isBorderlessAt(baseX * 16, baseY * 16)) {
            long i1 = mapRand.nextLong() / 2L * 2L + 1L;
            long j1 = mapRand.nextLong() / 2L * 2L + 1L;
            mapRand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            WorldGenVolcano.build(blocks, metadata, world, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
        }
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
    }
}

