/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.extrabiomes;

import extrabiomes.api.BiomeManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.extrabiomes.ConfigEBXL;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.extrabiomes.RealisticBiomeEBXLBase;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.surface.extrabiomes.SurfaceEBXLRedwoodLush;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.extrabiomes.TerrainEBXLRedwoodLush;

public class RealisticBiomeEBXLRedwoodLush
extends RealisticBiomeEBXLBase {
    public static BiomeGenBase ebxlBiome = (BiomeGenBase)BiomeManager.redwoodlush.get();
    public static Block topBlock = RealisticBiomeEBXLRedwoodLush.ebxlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeEBXLRedwoodLush.ebxlBiome.field_76753_B;

    public RealisticBiomeEBXLRedwoodLush() {
        super(ebxlBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.WET), (TerrainBase)new TerrainEBXLRedwoodLush(), new SurfaceEBXLRedwoodLush(topBlock, fillerBlock, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150346_d, 2, 0.1f));
        this.setRealisticBiomeName("EBXL Redwood Lush");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigEBXL.weightEBXLRedwoodLush;
        this.generateVillages = ConfigEBXL.villageEBXLRedwoodLush;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int z22;
        int x22;
        int y22;
        float l = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        int b1 = 0;
        while ((float)b1 < l * strength) {
            if (rand.nextInt(3) != 0) {
                RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
            }
            ++b1;
        }
        if (rand.nextInt((int)(8.0f / strength)) == 0 && (y22 = world.func_72976_f(x22 = chunkX + rand.nextInt(16) + 8, z22 = chunkY + rand.nextInt(16) + 8)) < 100) {
            if (rand.nextBoolean()) {
                new WorldGenLog(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, -1, 3 + rand.nextInt(4)).func_76484_a(world, rand, x22, y22, z22);
            } else {
                new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
            }
        }
        int f24 = 0;
        while ((float)f24 < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 110) {
                new WorldGenTreeShrub(rand.nextInt(4) + 1, 0, rand.nextInt(3)).func_76484_a(world, rand, i1, k1, j1);
            }
            ++f24;
        }
        int f23 = 0;
        while ((float)f23 < 8.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new WorldGenFlowers(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }
}

