/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.enhancedbiomes;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import rtg.config.enhancedbiomes.ConfigEB;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.enhancedbiomes.RealisticBiomeEBBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBWastelands;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.enhancedbiomes.TerrainEBWastelands;

public class RealisticBiomeEBWastelands
extends RealisticBiomeEBBase {
    public static Block[] ebDominantStoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b)};
    public static byte[] ebDominantStoneMeta = new byte[]{EBAPI.ebStonify((byte)11, (byte)0), EBAPI.ebStonify((byte)0, (byte)0)};
    public static Block[] ebDominantCobblestoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e)};
    public static byte[] ebDominantCobblestoneMeta = new byte[]{EBAPI.ebStonify((byte)11, (byte)0), EBAPI.ebStonify((byte)0, (byte)0)};
    private static Block cobbleBlock = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e);
    private static byte cobbleByte = EBAPI.ebStonify((byte)11, (byte)0);

    public RealisticBiomeEBWastelands(BiomeGenBase ebBiome) {
        super(ebBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.TEMPERATE), (TerrainBase)new TerrainEBWastelands(), new SurfaceEBWastelands(Blocks.field_150351_n, 0, cobbleBlock, cobbleByte, Blocks.field_150346_d, 0, cobbleBlock, cobbleByte, cobbleBlock, cobbleByte, cobbleBlock, cobbleByte, 40.0f, -0.1f, 10.0f, 0.5f));
        this.setRealisticBiomeName("EB Wastelands");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigEB.weightEBWastelands;
        this.generateVillages = ConfigEB.villageEBWastelands;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && (k1 < 64 || rand.nextInt(8) == 0)) {
                new WorldGenBlob(cobbleBlock, cobbleByte, rand.nextInt(1), rand).generate(world, rand, i1, k1, j1, true);
            }
            ++l;
        }
        float l2 = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        int i15 = 0;
        while ((float)i15 < 1.0f * strength) {
            int i17 = chunkX + rand.nextInt(16) + 8;
            int i20 = 64 + rand.nextInt(64);
            int l22 = chunkY + rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            ++i15;
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(16) == 0) {
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
            ++l14;
        }
    }
}

