/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.enhancedbiomes;

import enhancedbiomes.EnhancedBiomesMod;
import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.enhancedbiomes.ConfigEB;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.enhancedbiomes.RealisticBiomeEBBase;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenVolcano;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceRiverOasis;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBVolcano;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.enhancedbiomes.TerrainEBVolcano;

public class RealisticBiomeEBVolcano
extends RealisticBiomeEBBase {
    public static Block[] ebDominantStoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b)};
    public static byte[] ebDominantStoneMeta = new byte[]{EBAPI.ebStonify((byte)10, (byte)0), EBAPI.ebStonify((byte)3, (byte)0)};
    public static Block[] ebDominantCobblestoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e)};
    public static byte[] ebDominantCobblestoneMeta = new byte[]{EBAPI.ebStonify((byte)10, (byte)0), EBAPI.ebStonify((byte)3, (byte)0)};
    private static Block ebTopBlock = EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.grassEB, (Block)Blocks.field_150349_c);
    private static byte ebTopByte = EBAPI.ebGrassify((byte)1, (byte)0);
    private static Block ebFillBlock = EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.dirtEB, Blocks.field_150346_d);
    private static byte ebFillByte = EBAPI.ebGrassify((byte)1, (byte)0);
    private static Block ebMixTopBlock = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b);
    private static byte ebMixTopByte = EBAPI.ebStonify((byte)0, (byte)0);
    private static Block ebMixFillBlock = EnhancedBiomesMod.useNewStone == 1 ? EnhancedBiomesBlocks.stoneCobbleEB : Blocks.field_150347_e;
    private static byte ebMixFillByte = EBAPI.ebStonify((byte)0, (byte)0);
    private static Block ebCliff1Block = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b);
    private static byte ebCliff1Byte = EBAPI.ebStonify((byte)0, (byte)0);
    private static Block ebCliff2Block = EnhancedBiomesMod.useNewStone == 1 ? EnhancedBiomesBlocks.stoneCobbleEB : Blocks.field_150347_e;
    private static byte ebCliff2Byte = EBAPI.ebStonify((byte)0, (byte)0);
    private static SurfaceBase surface = new SurfaceEBVolcano(ebTopBlock, ebTopByte, ebFillBlock, ebFillByte, ebMixTopBlock, ebMixTopByte, ebMixFillBlock, ebMixFillByte, ebCliff1Block, ebCliff1Byte, ebCliff2Block, ebCliff2Byte, 80.0f, -0.15f, 10.0f, 0.5f);
    private static SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeEBVolcano(BiomeGenBase ebBiome) {
        super(ebBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainEBVolcano(), surface);
        this.setRealisticBiomeName("EB Volcano");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigEB.weightEBVolcano;
        this.generateVillages = ConfigEB.villageEBVolcano;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (ConfigRTG.enableVolcanoEruptions) {
            RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        }
        this.rGenerateEmeralds(world, rand, chunkX, chunkY, false);
        for (int l14 = 0; l14 < 15; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(3) == 0) {
                new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
        }
    }

    @Override
    public void rMapGen(Block[] blocks, byte[] metadata, World world, WorldChunkManagerRTG cmr, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        float river;
        if (baseX % 4 == 0 && baseY % 4 == 0 && mapRand.nextInt(6) == 0 && (river = cmr.getRiverStrength(baseX * 16, baseY * 16) + 1.0f) > 0.98f && cmr.isBorderlessAt(baseX * 16, baseY * 16)) {
            long i1 = mapRand.nextLong() / 2L * 2L + 1L;
            long j1 = mapRand.nextLong() / 2L * 2L + 1L;
            mapRand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            WorldGenVolcano.build(blocks, metadata, world, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
        }
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
    }
}

