/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.enhancedbiomes;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.world.gen.WorldGenSpikedBush;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.enhancedbiomes.ConfigEB;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.enhancedbiomes.RealisticBiomeEBBase;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBScrub;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.enhancedbiomes.TerrainEBScrub;

public class RealisticBiomeEBScrub
extends RealisticBiomeEBBase {
    public static Block[] ebDominantStoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b)};
    public static byte[] ebDominantStoneMeta = new byte[]{EBAPI.ebStonify((byte)7, (byte)0), EBAPI.ebStonify((byte)2, (byte)0)};
    public static Block[] ebDominantCobblestoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e)};
    public static byte[] ebDominantCobblestoneMeta = new byte[]{EBAPI.ebStonify((byte)7, (byte)0), EBAPI.ebStonify((byte)2, (byte)0)};
    private static Block ebTopBlock = Blocks.field_150354_m;
    private static byte ebTopByte = 0;
    private static Block ebFillBlock = EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.dirtEB, Blocks.field_150346_d);
    private static byte ebFillByte = EBAPI.ebGrassify((byte)7, (byte)0);
    private static Block ebMixTopBlock = EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.grassEB, (Block)Blocks.field_150349_c);
    private static byte ebMixTopByte = EBAPI.ebGrassify((byte)7, (byte)0);
    private static Block ebMixFillBlock = EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.dirtEB, Blocks.field_150346_d);
    private static byte ebMixFillByte = EBAPI.ebGrassify((byte)7, (byte)0);
    private static Block ebCliff1Block = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b);
    private static byte ebCliff1Byte = EBAPI.ebStonify((byte)2, (byte)0);
    private static Block ebCliff2Block = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e);
    private static byte ebCliff2Byte = EBAPI.ebStonify((byte)2, (byte)0);

    public RealisticBiomeEBScrub(BiomeGenBase ebBiome) {
        super(ebBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainEBScrub(), new SurfaceEBScrub(ebTopBlock, ebTopByte, ebFillBlock, ebFillByte, ebMixTopBlock, ebMixTopByte, ebMixFillBlock, ebMixFillByte, ebCliff1Block, ebCliff1Byte, ebCliff2Block, ebCliff2Byte, 80.0f, -0.15f, 10.0f, 0.5f));
        this.setRealisticBiomeName("EB Scrub");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigEB.weightEBScrub;
        this.generateVillages = ConfigEB.villageEBScrub;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        float l = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        int f24 = 0;
        while ((float)f24 < 2.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 110) {
                if (rand.nextInt(4) != 0) {
                    new WorldGenSpikedBush(Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0, EBAPI.ebGrassify((Block)EnhancedBiomesBlocks.dirtEB, Blocks.field_150346_d)).func_76484_a(world, rand, i1, k1, j1);
                } else {
                    new WorldGenTreeShrub(rand.nextInt(4) + 1, 0, rand.nextInt(3)).func_76484_a(world, rand, i1, k1, j1);
                }
            }
            ++f24;
        }
        int f23 = 0;
        while ((float)f23 < 8.0f * strength) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new WorldGenFlowers(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}).func_76484_a(world, rand, j15, j17, j20);
            ++f23;
        }
        int l14 = 0;
        while ((float)l14 < 12.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }
}

