/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.enhancedbiomes;

import enhancedbiomes.EnhancedBiomesMod;
import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.helpers.TreeGen;
import enhancedbiomes.world.gen.WorldGenRockSpire;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rtg.config.enhancedbiomes.ConfigEB;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.enhancedbiomes.RealisticBiomeEBBase;
import rtg.world.gen.feature.WorldGenCacti;
import rtg.world.gen.feature.WorldGenFlowers;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.surface.SurfaceRiverOasis;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBRockyDesert;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.enhancedbiomes.TerrainEBRockyDesert;

public class RealisticBiomeEBRockyDesert
extends RealisticBiomeEBBase {
    public static Block[] ebDominantStoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b)};
    public static byte[] ebDominantStoneMeta = new byte[]{EBAPI.ebStonify((byte)2, (byte)0), EBAPI.ebStonify((byte)7, (byte)0)};
    public static Block[] ebDominantCobblestoneBlock = new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e), EBAPI.ebStonify(EnhancedBiomesBlocks.stoneCobbleEB, Blocks.field_150347_e)};
    public static byte[] ebDominantCobblestoneMeta = new byte[]{EBAPI.ebStonify((byte)2, (byte)0), EBAPI.ebStonify((byte)7, (byte)0)};
    private static Block ebTopBlock = Blocks.field_150354_m;
    private static byte ebTopByte = 0;
    private static Block ebFillBlock = Blocks.field_150322_A;
    private static byte ebFillByte = 0;
    private static Block ebMixTopBlock = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150322_A);
    private static byte ebMixTopByte = EBAPI.ebStonify((byte)2, (byte)0);
    private static Block ebMixFillBlock = Blocks.field_150322_A;
    private static byte ebMixFillByte = 0;
    private static Block ebCliff1Block = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b);
    private static byte ebCliff1Byte = EBAPI.ebStonify((byte)2, (byte)0);
    private static Block ebCliff2Block = ebDominantCobblestoneBlock[0];
    private static byte ebCliff2Byte = ebDominantCobblestoneMeta[0];
    private static SurfaceBase surface = new SurfaceEBRockyDesert(ebTopBlock, ebTopByte, ebFillBlock, ebFillByte, ebMixTopBlock, ebMixTopByte, ebMixFillBlock, ebMixFillByte, ebCliff1Block, ebCliff1Byte, ebCliff2Block, ebCliff2Byte, 80.0f, -0.15f, 10.0f, 0.5f);
    private static SurfaceBase riverSurface = new SurfaceRiverOasis();

    public RealisticBiomeEBRockyDesert(BiomeGenBase ebBiome) {
        super(ebBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainEBRockyDesert(230.0f, 60.0f, 0.0f), surface);
        this.setRealisticBiomeName("EB Rocky Desert");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigEB.weightEBRockyDesert;
        this.generateVillages = ConfigEB.villageEBRockyDesert;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        for (int i23 = 0; i23 < 1; ++i23) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 >= 80) continue;
            new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (river > 0.7f) {
            if (river > 0.86f) {
                int b33 = 0;
                while ((float)b33 < 10.0f * strength) {
                    int k10;
                    int j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if ((float)z52 < 100.0f || (float)z52 < 120.0f && rand.nextInt(10) == 0) {
                        WorldGenShrub worldgenerator = rand.nextInt(4) != 0 ? new WorldGenShrub(0, 0) : TreeGen.eucalyptus_shrub((Random)rand);
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b33;
                }
            }
            int f25 = 0;
            while ((float)f25 < 2.0f * strength) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
                ++f25;
            }
            for (int f23 = 0; f23 < 3; ++f23) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new WorldGenFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            for (int l14 = 0; l14 < 15; ++l14) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                    continue;
                }
                new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
        } else {
            if (rand.nextInt(8) == 0) {
                int j2 = chunkX + rand.nextInt(16) + 8;
                int j5 = chunkY + rand.nextInt(16) + 8;
                int l3 = world.func_72825_h(j2, j5);
                new WorldGenRockSpire(new Block[]{EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, Blocks.field_150348_b), EnhancedBiomesMod.useNewStone == 1 ? EnhancedBiomesBlocks.stoneCobbleEB : Blocks.field_150347_e, Blocks.field_150322_A}, new byte[]{EBAPI.ebStonify((byte)2, (byte)0), EBAPI.ebStonify((byte)2, (byte)0), 0}, 10).func_76484_a(world, rand, j2, l3, j5);
            }
            int k18 = 0;
            while ((float)k18 < 5.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = 64 + rand.nextInt(64);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenCacti(false).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
            int i15 = 0;
            while ((float)i15 < 1.0f * strength) {
                int i17 = chunkX + rand.nextInt(16) + 8;
                int i20 = 64 + rand.nextInt(64);
                int l22 = chunkY + rand.nextInt(16) + 8;
                new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
                ++i15;
            }
        }
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        riverSurface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
    }
}

