/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import rtg.config.biomesoplenty.ConfigBOP;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPRedwoodForest;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPRedwoodForest;

public class RealisticBiomeBOPRedwoodForest
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.redwoodForest;
    public static Block topBlock = RealisticBiomeBOPRedwoodForest.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPRedwoodForest.bopBiome.field_76753_B;

    public RealisticBiomeBOPRedwoodForest() {
        super(bopBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.TEMPERATE), (TerrainBase)new TerrainBOPRedwoodForest(63.0f, 80.0f, 30.0f), new SurfaceBOPRedwoodForest(topBlock, fillerBlock, false, null, 0.4f));
        this.setRealisticBiomeName("BOP Redwood Forest");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigBOP.weightBOPRedwoodForest;
        this.generateVillages = ConfigBOP.villageBOPRedwoodForest;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        float l = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        for (int i23 = 0; i23 < 1; ++i23) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(16) != 0) continue;
            if (rand.nextBoolean()) {
                new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
                continue;
            }
            new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (rand.nextInt(12) == 0) {
            int intLogLength;
            int logMeta;
            Block log;
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            int intLogRand = rand.nextInt(12);
            if (intLogRand < 3) {
                log = BOPCBlocks.logs3;
                logMeta = 0;
                intLogLength = 3 + rand.nextInt(6);
            } else if (intLogRand < 9) {
                log = BOPCBlocks.logs3;
                logMeta = 0;
                intLogLength = 3 + rand.nextInt(8);
            } else {
                log = BOPCBlocks.logs3;
                logMeta = 0;
                intLogLength = 3 + rand.nextInt(10);
            }
            new WorldGenLog(log, logMeta, (Block)Blocks.field_150362_t, -1, intLogLength).func_76484_a(world, rand, x22, y22, z22);
        }
    }
}

