/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.biomesoplenty.ConfigBOP;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.feature.WorldGenBlob;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPMountain;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPMountain;

public class RealisticBiomeBOPMountain
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.mountain;
    public static Block topBlock = RealisticBiomeBOPMountain.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPMountain.bopBiome.field_76753_B;

    public RealisticBiomeBOPMountain() {
        super(bopBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainBOPMountain(200.0f, 100.0f, 0.0f), new SurfaceBOPMountain(topBlock, 0, fillerBlock, 0, topBlock, 0, fillerBlock, 0, 80.0f, -0.15f, 10.0f, 0.5f));
        this.setRealisticBiomeName("BOP Mountain");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigBOP.weightBOPMountain;
        this.generateVillages = ConfigBOP.villageBOPMountain;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        this.rRemoveEmeralds(world, rand, chunkX, chunkY, false);
        int l = 0;
        while ((float)l < 3.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 95 && rand.nextInt(16) == 0) {
                new WorldGenBlob(Blocks.field_150347_e, 0, rand).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        float l2 = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        if (l2 > 0.0f && rand.nextInt(6) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(BOPCBlocks.logs4, 0, BOPCBlocks.colorizedLeaves1, -1, 3 + rand.nextInt(4)).func_76484_a(world, rand, x22, y22, z22);
        }
        int b = 0;
        while ((float)b < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(10) == 0) {
                new WorldGenTreeShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            }
            ++b;
        }
        int l14 = 0;
        while ((float)l14 < 3.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            ++l14;
        }
    }
}

