/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.config.biomesoplenty.ConfigBOP;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.feature.WorldGenJungleCacti;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPLushDesert;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPLushDesert;

public class RealisticBiomeBOPLushDesert
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.lushDesert;
    public static Block topBlock = RealisticBiomeBOPLushDesert.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPLushDesert.bopBiome.field_76753_B;

    public RealisticBiomeBOPLushDesert() {
        super(bopBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.OASIS), (TerrainBase)new TerrainBOPLushDesert(63.0f, 69.0f, 40.0f), new SurfaceBOPLushDesert(topBlock, 0, fillerBlock, 0, topBlock, 0, fillerBlock, 0, 40.0f, -0.15f, 10.0f, 0.5f));
        this.setRealisticBiomeName("BOP Lush Desert");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigBOP.weightBOPLushDesert;
        this.generateVillages = ConfigBOP.villageBOPLushDesert;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        float l = simplex.noise2((float)chunkX / 80.0f, (float)chunkY / 80.0f) * 60.0f - 15.0f;
        for (int i23 = 0; i23 < 1; ++i23) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(16) != 0) continue;
            new WorldGenBlockBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        if (l > 0.0f && rand.nextInt(6) == 0) {
            int intLogLength;
            int logMeta;
            Block log;
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            int intLogRand = rand.nextInt(12);
            if (intLogRand < 3) {
                log = Blocks.field_150363_s;
                logMeta = 1;
                intLogLength = 3 + rand.nextInt(4);
            } else if (intLogRand < 9) {
                log = BOPCBlocks.logs3;
                logMeta = 2;
                intLogLength = 3 + rand.nextInt(2);
            } else {
                log = Blocks.field_150364_r;
                logMeta = 0;
                intLogLength = 3 + rand.nextInt(2);
            }
            new WorldGenLog(log, logMeta, (Block)Blocks.field_150362_t, -1, intLogLength).func_76484_a(world, rand, x22, y22, z22);
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            int k18 = 0;
            while ((float)k18 < 8.0f * strength) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = rand.nextInt(160);
                int k24 = chunkY + rand.nextInt(16) + 8;
                if ((float)j23 < 120.0f) {
                    new WorldGenJungleCacti(false, rand.nextInt(5), 1).func_76484_a(world, rand, k21, j23, k24);
                }
                ++k18;
            }
        }
    }
}

