/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.content.BOPCBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.biomesoplenty.ConfigBOP;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;
import rtg.world.gen.feature.WorldGenLog;
import rtg.world.gen.feature.tree.WorldGenTreeShrub;
import rtg.world.gen.surface.biomesoplenty.SurfaceBOPAlpsForest;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.biomesoplenty.TerrainBOPAlpsForest;

public class RealisticBiomeBOPAlpsForest
extends RealisticBiomeBOPBase {
    public static BiomeGenBase bopBiome = BOPCBiomes.alpsForest;
    public static Block topBlock = RealisticBiomeBOPAlpsForest.bopBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeBOPAlpsForest.bopBiome.field_76753_B;

    public RealisticBiomeBOPAlpsForest() {
        super(bopBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76777_m, BiomeBase.Climate.ICE), (TerrainBase)new TerrainBOPAlpsForest(), new SurfaceBOPAlpsForest(topBlock, fillerBlock, false, null, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150348_b, 0.15f));
        this.setRealisticBiomeName("BOP Alps Forest");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigBOP.weightBOPAlpsForest;
        this.generateVillages = ConfigBOP.villageBOPAlpsForest;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        this.rGenerateEmeralds(world, rand, chunkX, chunkY, false);
        float l = simplex.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 6.0f + 0.8f;
        if (l > 0.0f && rand.nextInt(12) == 0) {
            int x22 = chunkX + rand.nextInt(16) + 8;
            int z22 = chunkY + rand.nextInt(16) + 8;
            int y22 = world.func_72976_f(x22, z22);
            new WorldGenLog(1, 3 + rand.nextInt(4), false).func_76484_a(world, rand, x22, y22, z22);
        }
        int b = 0;
        while ((float)b < 2.0f * strength) {
            int i1 = chunkX + rand.nextInt(16) + 8;
            int j1 = chunkY + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1);
            if (rand.nextInt(8) == 0) {
                if (rand.nextInt(10) == 0) {
                    new WorldGenTreeShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                } else {
                    new WorldGenTreeShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                }
            }
            ++b;
        }
    }
}

