/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.atg;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.atg.ConfigATG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.atg.RealisticBiomeATGBase;
import rtg.world.gen.feature.WorldGenGrass;
import rtg.world.gen.feature.WorldGenVolcano;
import rtg.world.gen.surface.atg.SurfaceATGVolcano;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.atg.TerrainATGVolcano;

public class RealisticBiomeATGVolcano
extends RealisticBiomeATGBase {
    public RealisticBiomeATGVolcano(BiomeGenBase atgBiome) {
        super(atgBiome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.HOT), (TerrainBase)new TerrainATGVolcano(), new SurfaceATGVolcano(atgBiome.field_76752_A, atgBiome.field_76753_B, true, Blocks.field_150351_n, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150351_n, 0.08f));
        this.setRealisticBiomeName("ATG Volcano");
        this.biomeSize = BiomeBase.BiomeSize.NORMAL;
        this.biomeWeight = ConfigATG.weightATGVolcano;
        this.generateVillages = ConfigATG.villageATGVolcano;
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        RealisticBiomeBase.rDecorateSeedBiome(world, rand, chunkX, chunkY, simplex, cell, strength, river, this.baseBiome);
        for (int l14 = 0; l14 < 15; ++l14) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(128);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(3) == 0) {
                new WorldGenGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                continue;
            }
            new WorldGenGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
        }
    }

    @Override
    public void rMapGen(Block[] blocks, byte[] metadata, World world, WorldChunkManagerRTG cmr, Random mapRand, int baseX, int baseY, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        float river;
        if (baseX % 4 == 0 && baseY % 4 == 0 && mapRand.nextInt(6) == 0 && (river = cmr.getRiverStrength(baseX * 16, baseY * 16) + 1.0f) > 0.98f && cmr.isBorderlessAt(baseX * 16, baseY * 16)) {
            long i1 = mapRand.nextLong() / 2L * 2L + 1L;
            long j1 = mapRand.nextLong() / 2L * 2L + 1L;
            mapRand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            WorldGenVolcano.build(blocks, metadata, world, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
        }
    }
}

