/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class RealisticBiomePool {
    private ArrayList<Integer> biomePool;
    private CellNoise biomecell;
    private Random rand;
    private ArrayList<Integer> biomes_all;
    private int biomes_allLength;

    public RealisticBiomePool(CellNoise bc, Random r) {
        this.biomecell = bc;
        this.rand = r;
        this.biomePool = new ArrayList();
        this.biomes_all = new ArrayList();
        this.biomes_all.addAll(BiomeBase.biomes_snow);
        this.biomes_all.addAll(BiomeBase.biomes_cold);
        this.biomes_all.addAll(BiomeBase.biomes_wet);
        this.biomes_all.addAll(BiomeBase.biomes_hot);
        this.biomes_allLength = this.biomes_all.size();
        int minTemp = 1000000;
        int maxTemp = -1000000;
        for (int intBiomeIndex = 0; intBiomeIndex < this.biomes_allLength; ++intBiomeIndex) {
            RealisticBiomeBase rb = RealisticBiomeBase.getBiome(this.biomes_all.get(intBiomeIndex));
            BiomeGenBase rbb = rb.baseBiome;
            float rbbtemp = rbb.field_76750_F;
            int btemp = (int)(rbbtemp * 100.0f);
            minTemp = btemp < minTemp ? btemp : minTemp;
            maxTemp = btemp > maxTemp ? btemp : maxTemp;
        }
        for (int intTempIndex = minTemp; intTempIndex <= maxTemp; ++intTempIndex) {
            for (int intBiomeIndex = 0; intBiomeIndex < this.biomes_all.size(); ++intBiomeIndex) {
                RealisticBiomeBase rb = RealisticBiomeBase.getBiome(this.biomes_all.get(intBiomeIndex));
                BiomeGenBase rbb = rb.baseBiome;
                float rbbtemp = rbb.field_76750_F;
                int btemp = (int)(rbbtemp * 100.0f);
                if (btemp != intTempIndex) continue;
                this.biomePool.add(rb.baseBiome.field_76756_M);
                if (!ConfigRTG.enableDebugging) continue;
                FMLLog.log((Level)Level.INFO, (String)"Added %s at temp %d.", (Object[])new Object[]{rb.getRealisticBiomeName(), btemp});
            }
        }
    }

    public RealisticBiomeBase chooseBiome(double par1, double par2) {
        RealisticBiomeBase output = null;
        int biomeSize = ConfigRTG.biomeSize;
        int normalSize = 3;
        int normalDivisor = 450;
        biomeSize = normalDivisor * biomeSize / normalSize;
        float bcn = this.biomecell.noise(par1 / (double)biomeSize, par2 / (double)biomeSize, 1.0);
        bcn = (bcn = this.normalize(bcn, -1.0f, 1.0f, 0.0f, 1.0f)) < 0.0f ? 0.0f : (bcn >= 0.9999999f ? 0.9999999f : bcn);
        output = RealisticBiomeBase.getBiome(this.biomePool.get((int)(bcn *= (float)this.biomePool.size())));
        return output;
    }

    private float normalize(float value, float minOld, float maxOld, float minNew, float maxNew) {
        return (maxNew - minNew) / (maxOld - minOld) * (value - maxOld) + maxNew;
    }
}

