/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import org.apache.logging.log4j.Level;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.RandomUtil;
import rtg.world.biome.BiomeBase;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.gen.feature.WorldGenClay;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeBase
extends BiomeBase {
    private static final RealisticBiomeBase[] arrRealisticBiomeIds = new RealisticBiomeBase[256];
    public final BiomeGenBase baseBiome;
    public final BiomeGenBase riverBiome;
    public String realisticBiomeName = null;
    public BiomeBase.BiomeSize biomeSize;
    public int biomeWeight = 10;
    public TerrainBase terrain;
    public SurfaceBase[] surfaces;
    public int surfacesLength;
    public int waterSurfaceLakeChance;
    public int lavaSurfaceLakeChance;
    public int waterUndergroundLakeChance;
    public int lavaUndergroundLakeChance;
    public int clayPerChunk;
    public int dirtPerChunk;
    public int gravelPerChunk;
    public int coalPerChunk;
    public int ironPerChunk;
    public int goldPerChunk;
    public int redstonePerChunk;
    public int diamondPerChunk;
    public int lapisPerChunk;
    public boolean generateVillages;
    public Block emeraldEmeraldBlock;
    public byte emeraldEmeraldMeta;
    public Block emeraldStoneBlock;
    public byte emeraldStoneMeta;

    public RealisticBiomeBase(BiomeGenBase biome) {
        this(biome, BiomeBase.climatizedBiome(BiomeGenBase.field_76781_i, BiomeBase.Climate.TEMPERATE));
    }

    public RealisticBiomeBase(BiomeGenBase biome, BiomeGenBase river) {
        super(biome.field_76756_M);
        RealisticBiomeBase.arrRealisticBiomeIds[biome.field_76756_M] = this;
        this.baseBiome = biome;
        this.riverBiome = river;
        this.waterSurfaceLakeChance = 10;
        this.lavaSurfaceLakeChance = 0;
        this.waterUndergroundLakeChance = 1;
        this.lavaUndergroundLakeChance = 1;
        this.clayPerChunk = 20;
        this.dirtPerChunk = 32;
        this.gravelPerChunk = 32;
        this.coalPerChunk = 16;
        this.ironPerChunk = 8;
        this.goldPerChunk = 8;
        this.redstonePerChunk = 7;
        this.diamondPerChunk = 7;
        this.lapisPerChunk = 6;
        this.generateVillages = true;
        this.emeraldEmeraldBlock = Blocks.field_150412_bA;
        this.emeraldEmeraldMeta = 0;
        this.emeraldStoneBlock = Blocks.field_150348_b;
        this.emeraldStoneMeta = 0;
    }

    public static RealisticBiomeBase getBiome(int id) {
        return arrRealisticBiomeIds[id];
    }

    public RealisticBiomeBase(BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase[] s) {
        this(b, riverbiome);
        this.terrain = t;
        this.surfaces = s;
        this.surfacesLength = s.length;
    }

    public RealisticBiomeBase(BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        this(b, riverbiome, t, new SurfaceBase[]{s});
    }

    public void rPopulatePreDecorate(IChunkProvider ichunkprovider, World worldObj, Random rand, int chunkX, int chunkZ, boolean flag) {
        int l4;
        int i8;
        int i82;
        int l42;
        int i2;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        boolean gen = true;
        gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE);
        if (ConfigRTG.enableWaterUndergroundLakes && gen && this.waterUndergroundLakeChance > 0) {
            i2 = worldX + rand.nextInt(16) + 8;
            l42 = RandomUtil.getRandomInt(rand, 1, 50);
            i82 = worldZ + rand.nextInt(16) + 8;
            if (rand.nextInt(this.waterUndergroundLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.waterUndergroundLakeChance) == 1) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(worldObj, rand, i2, l42, i82);
            }
        }
        if (ConfigRTG.enableWaterSurfaceLakes && gen && this.waterSurfaceLakeChance > 0) {
            i2 = worldX + rand.nextInt(16) + 8;
            i8 = worldZ + rand.nextInt(16) + 8;
            l4 = worldObj.func_72976_f(i2, i8);
            if (rand.nextInt(this.waterSurfaceLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.waterSurfaceLakeChance) == 1 && l4 > 63) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(worldObj, rand, i2, l4, i8);
            }
        }
        gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA);
        if (ConfigRTG.enableLavaUndergroundLakes && gen && this.lavaUndergroundLakeChance > 0) {
            i2 = worldX + rand.nextInt(16) + 8;
            l42 = RandomUtil.getRandomInt(rand, 1, 50);
            i82 = worldZ + rand.nextInt(16) + 8;
            if (rand.nextInt(this.lavaUndergroundLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.lavaUndergroundLakeChance) == 1) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(worldObj, rand, i2, l42, i82);
            }
        }
        if (ConfigRTG.enableLavaSurfaceLakes && gen && this.lavaSurfaceLakeChance > 0) {
            i2 = worldX + rand.nextInt(16) + 8;
            i8 = worldZ + rand.nextInt(16) + 8;
            l4 = worldObj.func_72976_f(i2, i8);
            if (rand.nextInt(this.lavaSurfaceLakeChance) == 0 && RandomUtil.getRandomInt(rand, 1, ConfigRTG.lavaSurfaceLakeChance) == 1 && l4 > 63) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(worldObj, rand, i2, l4, i8);
            }
        }
        if (ConfigRTG.generateDungeons) {
            gen = TerrainGen.populate((IChunkProvider)ichunkprovider, (World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            for (int k1 = 0; k1 < 8 && gen; ++k1) {
                int j5 = worldX + rand.nextInt(16) + 8;
                int k8 = rand.nextInt(128);
                int j11 = worldZ + rand.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(worldObj, rand, j5, k8, j11);
            }
        }
    }

    public void rDecorate(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river) {
        if (strength > 0.3f) {
            this.baseBiome.func_76728_a(world, rand, chunkX, chunkY);
        }
    }

    public void rPopulatePostDecorate() {
    }

    public static void rDecorateSeedBiome(World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, BiomeGenBase seedBiome) {
        if (strength > 0.3f) {
            seedBiome.func_76728_a(world, rand, chunkX, chunkY);
        }
    }

    public void generateMapGen(Block[] blocks, byte[] metadata, Long seed, World world, WorldChunkManagerRTG cmr, Random mapRand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
        int k = 5;
        mapRand.setSeed(seed);
        long l = mapRand.nextLong() / 2L * 2L + 1L;
        long l1 = mapRand.nextLong() / 2L * 2L + 1L;
        for (int baseX = chunkX - k; baseX <= chunkX + k; ++baseX) {
            for (int baseY = chunkY - k; baseY <= chunkY + k; ++baseY) {
                mapRand.setSeed((long)baseX * l + (long)baseY * l1 ^ seed);
                this.rMapGen(blocks, metadata, world, cmr, mapRand, baseX, baseY, chunkX, chunkY, simplex, cell, noise);
            }
        }
    }

    public void rMapGen(Block[] blocks, byte[] metadata, World world, WorldChunkManagerRTG cmr, Random mapRand, int chunkX, int chunkY, int baseX, int baseY, OpenSimplexNoise simplex, CellNoise cell, float[] noise) {
    }

    public float rNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return this.terrain.generateNoise(simplex, cell, x, y, border, river);
    }

    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        for (int s = 0; s < this.surfacesLength; ++s) {
            this.surfaces[s].paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, simplex, cell, noise, river, base);
        }
    }

    public float r3Dnoise(float z) {
        return 0.0f;
    }

    public String getRealisticBiomeName() {
        return this.realisticBiomeName;
    }

    public void setRealisticBiomeName(String n) {
        this.realisticBiomeName = n;
    }

    public void rGenerateOres(World worldObj, Random rand, int worldX, int worldZ) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldObj, rand, worldX, worldZ));
        this.rGenerateOreDirt(worldObj, rand, worldX, worldZ);
        this.rGenerateOreGravel(worldObj, rand, worldX, worldZ);
        this.rGenerateOreCoal(worldObj, rand, worldX, worldZ);
        this.rGenerateOreIron(worldObj, rand, worldX, worldZ);
        this.rGenerateOreGold(worldObj, rand, worldX, worldZ);
        this.rGenerateOreRedstone(worldObj, rand, worldX, worldZ);
        this.rGenerateOreDiamond(worldObj, rand, worldX, worldZ);
        this.rGenerateOreLapis(worldObj, rand, worldX, worldZ);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldObj, rand, worldX, worldZ));
    }

    public void rGenerateOreDirt(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_dirt = new WorldGenMinable(Blocks.field_150346_d, this.dirtPerChunk);
        if (TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_dirt, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            for (int j2 = 0; j2 < 10; ++j2) {
                int l5 = worldX + rand.nextInt(16);
                int i9 = rand.nextInt(64);
                int l11 = worldZ + rand.nextInt(16);
                ore_dirt.func_76484_a(worldObj, rand, l5, i9, l11);
            }
        }
    }

    public void rGenerateOreGravel(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_gravel = new WorldGenMinable(Blocks.field_150351_n, this.gravelPerChunk);
        if (TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_gravel, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            for (int k2 = 0; k2 < 5; ++k2) {
                int i6 = worldX + rand.nextInt(16);
                int j9 = rand.nextInt(64);
                int i12 = worldZ + rand.nextInt(16);
                ore_gravel.func_76484_a(worldObj, rand, i6, j9, i12);
            }
        }
    }

    public void rGenerateOreCoal(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_coal = new WorldGenMinable(Blocks.field_150365_q, this.coalPerChunk);
        if (ConfigRTG.generateOreCoal && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_coal, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            for (int i3 = 0; i3 < 20; ++i3) {
                int j6 = worldX + rand.nextInt(16);
                int k9 = rand.nextInt(128);
                int j12 = worldZ + rand.nextInt(16);
                ore_coal.func_76484_a(worldObj, rand, j6, k9, j12);
            }
        }
    }

    public void rGenerateOreIron(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_iron = new WorldGenMinable(Blocks.field_150366_p, this.ironPerChunk);
        if (ConfigRTG.generateOreIron && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_iron, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            for (int j3 = 0; j3 < 20; ++j3) {
                int k6 = worldX + rand.nextInt(16);
                int l9 = rand.nextInt(64);
                int k12 = worldZ + rand.nextInt(16);
                ore_iron.func_76484_a(worldObj, rand, k6, l9, k12);
            }
        }
    }

    public void rGenerateOreGold(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_gold = new WorldGenMinable(Blocks.field_150352_o, this.goldPerChunk);
        if (ConfigRTG.generateOreGold && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_gold, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            for (int k3 = 0; k3 < 2; ++k3) {
                int l6 = worldX + rand.nextInt(16);
                int i10 = rand.nextInt(32);
                int l12 = worldZ + rand.nextInt(16);
                ore_gold.func_76484_a(worldObj, rand, l6, i10, l12);
            }
        }
    }

    public void rGenerateOreRedstone(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_redstone = new WorldGenMinable(Blocks.field_150450_ax, this.redstonePerChunk);
        if (ConfigRTG.generateOreRedstone && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_redstone, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            for (int l3 = 0; l3 < 8; ++l3) {
                int i7 = worldX + rand.nextInt(16);
                int j10 = rand.nextInt(16);
                int i13 = worldZ + rand.nextInt(16);
                ore_redstone.func_76484_a(worldObj, rand, i7, j10, i13);
            }
        }
    }

    public void rGenerateOreDiamond(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_diamond = new WorldGenMinable(Blocks.field_150482_ag, this.diamondPerChunk);
        if (ConfigRTG.generateOreDiamond && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_diamond, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            for (int i4 = 0; i4 < 1; ++i4) {
                int j7 = worldX + rand.nextInt(16);
                int k10 = rand.nextInt(16);
                int j13 = worldZ + rand.nextInt(16);
                ore_diamond.func_76484_a(worldObj, rand, j7, k10, j13);
            }
        }
    }

    public void rGenerateOreLapis(World worldObj, Random rand, int worldX, int worldZ) {
        WorldGenMinable ore_lapis = new WorldGenMinable(Blocks.field_150369_x, this.lapisPerChunk);
        if (ConfigRTG.generateOreLapis && TerrainGen.generateOre((World)worldObj, (Random)rand, (WorldGenerator)ore_lapis, (int)worldX, (int)worldZ, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            for (int j4 = 0; j4 < 1; ++j4) {
                int k7 = worldX + rand.nextInt(16);
                int l10 = rand.nextInt(16) + rand.nextInt(16);
                int k13 = worldZ + rand.nextInt(16);
                ore_lapis.func_76484_a(worldObj, rand, k7, l10, k13);
            }
        }
    }

    public void rDecorateClay(World worldObj, Random rand, int chunkX, int chunkZ, float river, int worldX, int worldZ) {
        if (TerrainGen.decorate((World)worldObj, (Random)rand, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY) && river > 0.85f) {
            for (int j2 = 0; j2 < 3; ++j2) {
                int l5 = worldX + rand.nextInt(16);
                int i9 = 53 + rand.nextInt(15);
                int l11 = worldZ + rand.nextInt(16);
                new WorldGenClay(Blocks.field_150435_aG, 0, this.clayPerChunk).func_76484_a(worldObj, rand, l5, i9, l11);
            }
        }
    }

    public void rGenerateEmeralds(World world, Random rand, int chunkX, int chunkZ, boolean forceGeneration) {
        if (ConfigRTG.generateOreEmerald || forceGeneration) {
            for (int g12 = 0; g12 < 1; ++g12) {
                int p1;
                int m1;
                int n1 = chunkX + rand.nextInt(16);
                if (!world.func_147439_a(n1, m1 = rand.nextInt(28) + 4, p1 = chunkZ + rand.nextInt(16)).isReplaceableOreGen(world, n1, m1, p1, this.emeraldStoneBlock) || rand.nextInt(4) != 0) continue;
                world.func_147465_d(n1, m1, p1, this.emeraldEmeraldBlock, (int)this.emeraldEmeraldMeta, 2);
                if (!ConfigRTG.enableDebugging) continue;
                FMLLog.log((Level)Level.INFO, (String)"Emerald generated at %d, %d, %d", (Object[])new Object[]{n1, m1, p1});
            }
        }
    }

    public void rRemoveEmeralds(World world, Random rand, int chunkX, int chunkZ, boolean forceRemoval) {
        if (!ConfigRTG.generateOreEmerald || forceRemoval) {
            int endX = chunkX * 16 + 16;
            int endZ = chunkZ * 16 + 16;
            boolean enableDebugging = ConfigRTG.enableDebugging;
            int maxY = world.func_72976_f(chunkX, chunkZ);
            for (int x = chunkX * 16; x < endX; ++x) {
                for (int z = chunkZ * 16; z < endZ; ++z) {
                    for (int y = 0; y < maxY; ++y) {
                        if (!world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, this.emeraldEmeraldBlock)) continue;
                        world.func_147465_d(x, y, z, this.emeraldStoneBlock, (int)this.emeraldStoneMeta, 2);
                        if (!enableDebugging) continue;
                        FMLLog.log((Level)Level.INFO, (String)"Emerald replaced at %d, %d, %d", (Object[])new Object[]{x, y, z});
                    }
                }
            }
        }
    }
}

