/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.RealisticBiomePool;

public class WorldChunkManagerRTG
extends WorldChunkManager {
    private BiomeCache biomeCache;
    private List biomesToSpawnIn;
    private OpenSimplexNoise simplex;
    private CellNoise cell;
    private CellNoise biomecell;
    private float[] borderNoise;
    private Random rand;
    private TLongObjectHashMap<RealisticBiomeBase> biomeDataMap = new TLongObjectHashMap();
    private RealisticBiomePool biomePool;

    protected WorldChunkManagerRTG() {
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        this.biomesToSpawnIn = new ArrayList();
        this.borderNoise = new float[256];
    }

    public WorldChunkManagerRTG(World par1World) {
        this();
        long seed = par1World.func_72905_C();
        this.simplex = new OpenSimplexNoise(seed);
        this.cell = new CellNoise(seed, 0);
        this.cell.setUseDistance(true);
        this.biomecell = new CellNoise(seed, 0);
        this.rand = new Random(seed);
        this.biomePool = new RealisticBiomePool(this.biomecell, this.rand);
    }

    public int[] getBiomesGens(int par1, int par2, int par3, int par4) {
        int[] d = new int[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                d[j * par3 + i] = this.func_76935_a((int)(par1 + i), (int)(par2 + j)).field_76756_M;
            }
        }
        return d;
    }

    public RealisticBiomeBase[] getBiomesGensData(int par1, int par2, int par3, int par4) {
        RealisticBiomeBase[] data = new RealisticBiomeBase[par3 * par4];
        for (int i = 0; i < par3; ++i) {
            for (int j = 0; j < par4; ++j) {
                data[j * par3 + i] = this.getBiomeDataAt(par1 + i, par2 + j);
            }
        }
        return data;
    }

    public boolean diff(float sample1, float sample2, float base) {
        return sample1 < base && sample2 > base || sample1 > base && sample2 < base;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.getBiomeDataAt((int)par1, (int)par2).baseBiome;
    }

    public RealisticBiomeBase getBiomeDataAt(int par1, int par2) {
        long coords = ChunkCoordIntPair.func_77272_a((int)par1, (int)par2);
        if (this.biomeDataMap.containsKey(coords)) {
            return (RealisticBiomeBase)((Object)this.biomeDataMap.get(coords));
        }
        RealisticBiomeBase output = this.biomePool.chooseBiome(par1, par2);
        int generateOnlyThisBiomeId = ConfigRTG.generateOnlyThisBiomeId;
        if (generateOnlyThisBiomeId > -1) {
            output = RealisticBiomeBase.getBiome(generateOnlyThisBiomeId);
        }
        if (this.biomeDataMap.size() > 4096) {
            this.biomeDataMap.clear();
        }
        this.biomeDataMap.put(coords, (Object)output);
        return output;
    }

    public float getNoiseAt(int x, int y) {
        float river = this.getRiverStrength(x, y) + 1.0f;
        if (river < 0.5f) {
            return 59.0f;
        }
        return this.getBiomeDataAt(x, y).rNoise(this.simplex, this.cell, x, y, 1.0f, river);
    }

    public float calculateRiver(int x, int y, float st, float biomeHeight) {
        if (st < 0.0f && biomeHeight > 59.0f) {
            float pX = (float)x + this.simplex.noise1((float)y / 240.0f) * 220.0f;
            float pY = (float)y + this.simplex.noise1((float)x / 240.0f) * 220.0f;
            float r = this.cell.border((double)pX / 1250.0, (double)pY / 1250.0, 0.038461538461538464, 1.0f);
            return biomeHeight * (r + 1.0f) + (59.0f + this.simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 2.0f + this.simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 1.5f) * -r;
        }
        return biomeHeight;
    }

    public float getRiverStrength(int x, int y) {
        return this.cell.border((double)((float)x + this.simplex.noise1((float)y / 240.0f) * 220.0f) / 1250.0, (double)((float)y + this.simplex.noise1((float)x / 240.0f) * 220.0f) / 1250.0, 0.16666666666666666, 1.0f);
    }

    public boolean isBorderlessAt(int x, int y) {
        int by;
        int bx;
        for (bx = -2; bx <= 2; ++bx) {
            for (by = -2; by <= 2; ++by) {
                int n = this.getBiomeDataAt((int)(x + bx * 16), (int)(y + by * 16)).field_76756_M;
                this.borderNoise[n] = this.borderNoise[n] + 0.04f;
            }
        }
        by = 0;
        for (bx = 0; bx < 256; ++bx) {
            if (this.borderNoise[bx] > 0.98f) {
                by = 1;
            }
            this.borderNoise[bx] = 0.0f;
        }
        return by == 1;
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)BiomeGenBase.func_150568_d((int)var6[var7]).func_76744_g() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var7 = this.getBiomesGens(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.func_150568_d((int)var7[var8]);
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int x, int y, int par3, List par4List) {
        float centerNoise = this.getNoiseAt(x, y);
        if (centerNoise < 62.0f) {
            return false;
        }
        float lowestNoise = centerNoise;
        float highestNoise = centerNoise;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i == 0 || j == 0) continue;
                float n = this.getNoiseAt(x + i * 16, y + j * 16);
                if (n < lowestNoise) {
                    lowestNoise = n;
                }
                if (!(n > highestNoise)) continue;
                highestNoise = n;
            }
        }
        return highestNoise - lowestNoise < 22.0f;
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        return null;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

