/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;
import rtg.config.rtg.ConfigRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class BiomeBase
extends BiomeGenBase {
    public static final int DEFAULT_BIOME_SIZE = 3;
    public static final int MIN_BIOME_SIZE = 1;
    public static final int MAX_BIOME_SIZE = 20;
    public static final int DEFAULT_BIOME_WEIGHT = 10;
    public static final int MIN_BIOME_WEIGHT = 0;
    public static final int MAX_BIOME_WEIGHT = 100;
    public static ArrayList<Integer> biomes_snow;
    public static ArrayList<Integer> biomes_cold;
    public static ArrayList<Integer> biomes_hot;
    public static ArrayList<Integer> biomes_wet;
    public static float tempCold;
    public static float rainCold;
    public static float tempHot;
    public static float rainHot;
    public static float tempIce;
    public static float rainIce;
    public static float tempOasis;
    public static float rainOasis;
    public static float tempTemperate;
    public static float rainTemperate;
    public static float tempWet;
    public static float rainWet;
    public static ArrayList<BiomeGenBase> arrVillageBiomes;

    public BiomeBase(int intBiomeId) {
        super(intBiomeId, false);
    }

    public static BiomeGenBase climatizedBiome(BiomeGenBase biome, Climate climate) {
        switch (climate) {
            case COLD: {
                biome.func_76732_a(tempCold, rainCold);
                break;
            }
            case HOT: {
                biome.func_76732_a(tempHot, rainHot);
                break;
            }
            case ICE: {
                biome.func_76732_a(tempIce, rainIce);
                break;
            }
            case OASIS: {
                biome.func_76732_a(tempOasis, rainOasis);
                break;
            }
            case TEMPERATE: {
                biome.func_76732_a(tempTemperate, rainTemperate);
                break;
            }
            case WET: {
                biome.func_76732_a(tempWet, rainWet);
                break;
            }
        }
        return biome;
    }

    public static void init() {
        biomes_snow = new ArrayList();
        biomes_cold = new ArrayList();
        biomes_hot = new ArrayList();
        biomes_wet = new ArrayList();
        arrVillageBiomes = new ArrayList();
    }

    public static void addBiome(RealisticBiomeBase b, BiomeSize size) {
        try {
            BiomeBase.addWeightedBiome(b, size);
        }
        catch (Error e) {
            FMLLog.log((Level)Level.ERROR, (String)"Failed to add biome.", (Object[])new Object[0]);
        }
    }

    public static void addVillageBiome(RealisticBiomeBase b) {
        if (b.generateVillages) {
            arrVillageBiomes.add(b.baseBiome);
        }
    }

    public static void addBiome(RealisticBiomeBase b) {
        BiomeSize size = b.biomeSize;
        try {
            BiomeBase.addWeightedBiome(b, size);
        }
        catch (Error e) {
            FMLLog.log((Level)Level.ERROR, (String)"Failed to add biome.", (Object[])new Object[0]);
        }
    }

    public static void addWeightedBiome(RealisticBiomeBase b, BiomeSize size) {
        int weight = b.biomeWeight;
        weight = weight < 0 ? 0 : (weight > 100 ? 100 : weight);
        int biomeSize = ConfigRTG.biomeSize;
        int n = biomeSize < 1 ? 1 : (biomeSize = biomeSize > 20 ? 20 : biomeSize);
        if ((weight *= biomeSize) > 0) {
            block5: for (int i = 0; i < weight; ++i) {
                if (b.baseBiome.field_76750_F < 0.15f) {
                    biomes_snow.add(b.field_76756_M);
                    if (ConfigRTG.enableDebugging) {
                        FMLLog.log((Level)Level.INFO, (String)"Added %s to SNOW category (%d in total)", (Object[])new Object[]{b.getRealisticBiomeName(), biomes_snow.size()});
                    }
                } else if (b.baseBiome.field_76750_F <= 0.3f) {
                    biomes_cold.add(b.field_76756_M);
                    if (ConfigRTG.enableDebugging) {
                        FMLLog.log((Level)Level.INFO, (String)"Added %s to COLD category (%d in total)", (Object[])new Object[]{b.getRealisticBiomeName(), biomes_cold.size()});
                    }
                } else if (b.baseBiome.field_76750_F <= 1.0f) {
                    biomes_wet.add(b.field_76756_M);
                    if (ConfigRTG.enableDebugging) {
                        FMLLog.log((Level)Level.INFO, (String)"Added %s to WET category (%d in total)", (Object[])new Object[]{b.getRealisticBiomeName(), biomes_wet.size()});
                    }
                } else {
                    biomes_hot.add(b.field_76756_M);
                    if (ConfigRTG.enableDebugging) {
                        FMLLog.log((Level)Level.INFO, (String)"Added %s to HOT category (%d in total)", (Object[])new Object[]{b.getRealisticBiomeName(), biomes_hot.size()});
                    }
                }
                switch (size) {
                    case SMALL: {
                        continue block5;
                    }
                    case NORMAL: {
                        continue block5;
                    }
                    case LARGE: {
                        continue block5;
                    }
                }
            }
        }
    }

    static {
        tempCold = 0.2f;
        rainCold = 0.3f;
        tempHot = 2.0f;
        rainHot = 0.0f;
        tempIce = -0.5f;
        rainIce = 0.4f;
        tempOasis = 0.9f;
        rainOasis = 1.0f;
        tempTemperate = 0.8f;
        rainTemperate = 0.4f;
        tempWet = 0.95f;
        rainWet = 0.9f;
    }

    public static enum BiomeSize {
        LARGE,
        NORMAL,
        SMALL;

    }

    public static enum Climate {
        COLD,
        HOT,
        ICE,
        OASIS,
        TEMPERATE,
        WET;

    }
}

