/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.thaumcraft;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ConfigTC {
    public static Configuration config;
    public static final int biomeWeightMin = 0;
    public static final int biomeWeightMax = 100;
    public static final int biomeWeightDefault = 10;
    public static boolean generateTCBiomes;
    public static boolean generateTCTaintedLand;
    public static boolean generateTCMagicalForest;
    public static int weightTCTaintedLand;
    public static int weightTCMagicalForest;
    public static boolean villageTCTaintedLand;
    public static boolean villageTCMagicalForest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            generateTCBiomes = config.getBoolean("Allow biomes from this mod to generate", "Allow mod biomes", true, "If TRUE, uses the individual biome settings below. If FALSE, disables all biomes from this mod." + Configuration.NEW_LINE);
            generateTCTaintedLand = config.getBoolean(ConfigTC.formatConfig("generateTCTaintedLand"), "Biomes", generateTCTaintedLand, "");
            generateTCMagicalForest = config.getBoolean(ConfigTC.formatConfig("generateTCMagicalForest"), "Biomes", generateTCMagicalForest, "");
            weightTCTaintedLand = config.getInt(ConfigTC.formatConfig("weightTCTaintedLand"), "Weights", weightTCTaintedLand, 0, 100, "");
            weightTCMagicalForest = config.getInt(ConfigTC.formatConfig("weightTCMagicalForest"), "Weights", weightTCMagicalForest, 0, 100, "");
            villageTCTaintedLand = config.getBoolean(ConfigTC.formatConfig("villageTCTaintedLand"), "Villages", villageTCTaintedLand, "");
            villageTCMagicalForest = config.getBoolean(ConfigTC.formatConfig("villageTCMagicalForest"), "Villages", villageTCMagicalForest, "");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading Thaumcraft configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String formatConfig(String s) {
        String returnString = s;
        returnString = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)returnString), (String)" ");
        if (s.startsWith("generate")) {
            returnString = StringUtils.replace((String)returnString, (String)"generate", (String)"Generate", (int)1);
        } else if (s.startsWith("village")) {
            returnString = StringUtils.replace((String)returnString, (String)"village", (String)"Allow villages to generate in", (int)1);
        } else if (s.startsWith("weight")) {
            returnString = StringUtils.replace((String)returnString, (String)"weight", (String)"Weight of", (int)1);
        }
        return returnString;
    }

    static {
        generateTCBiomes = true;
        generateTCTaintedLand = true;
        generateTCMagicalForest = true;
        weightTCTaintedLand = (int)Math.floor(5.0);
        weightTCMagicalForest = (int)Math.floor(15.0);
        villageTCTaintedLand = false;
        villageTCMagicalForest = false;
    }
}

