/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.rtg;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigRTG {
    public static Configuration config;
    public static int generateOnlyThisBiomeId;
    public static boolean enableUBCStoneShadowing;
    public static boolean enableUBCDesertShadowing;
    public static String shadowStoneBlockId;
    public static int shadowStoneBlockByte;
    public static String shadowDesertBlockId;
    public static int shadowDesertBlockByte;
    public static String bedrockBlockId;
    public static int bedrockBlockByte;
    public static int duneHeight;
    public static String volcanoBlockId;
    public static int volcanoBlockByte;
    public static boolean enableVolcanoEruptions;
    public static boolean generateOreCoal;
    public static boolean generateOreIron;
    public static boolean generateOreGold;
    public static boolean generateOreRedstone;
    public static boolean generateOreLapis;
    public static boolean generateOreDiamond;
    public static boolean generateOreEmerald;
    public static boolean enableCobblestoneBoulders;
    public static int cobblestoneBoulderChance;
    public static boolean enableWaterSurfaceLakes;
    public static int waterSurfaceLakeChance;
    public static boolean enableWaterUndergroundLakes;
    public static int waterUndergroundLakeChance;
    public static boolean enableLavaSurfaceLakes;
    public static int lavaSurfaceLakeChance;
    public static boolean enableLavaUndergroundLakes;
    public static int lavaUndergroundLakeChance;
    public static boolean generateMineshafts;
    public static boolean generateStrongholds;
    public static boolean generateVillages;
    public static boolean generateScatteredFeatures;
    public static boolean generateDungeons;
    public static boolean enableCaves;
    public static int caveDensity;
    public static int caveFrequency;
    public static boolean enableSnowLayers;
    public static int flatBedrockLayers;
    public static boolean showDebugInfo;
    public static boolean enableDebugging;
    public static int biomeSize;
    public static int minDistanceScatteredFeatures;
    public static int maxDistanceScatteredFeatures;
    public static boolean enableVillageModifications;
    public static int villageSize;
    public static int minDistanceVillages;
    public static int maxDistanceVillages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            flatBedrockLayers = config.getInt("Number of flat bedrock layers", "Bedrock", flatBedrockLayers, 0, 5, "0 = Normal bedrock (rough pattern); 1-5 = Number of flat bedrock layers to generate" + Configuration.NEW_LINE);
            bedrockBlockId = config.getString("Bedrock block ID", "Bedrock", bedrockBlockId, "The block to use for the bottom of the Overworld." + Configuration.NEW_LINE);
            bedrockBlockByte = config.getInt("Bedrock block meta value", "Bedrock", bedrockBlockByte, 0, 15, "The meta value of the bedrock block." + Configuration.NEW_LINE);
            generateOnlyThisBiomeId = config.getInt("Generate only this biome ID", "Biomes", generateOnlyThisBiomeId, -1, 255, "If you enter a biome ID here, the whole world will consist of only that biome (and rivers). Set to -1 to generate the world normally." + Configuration.NEW_LINE + "Vanilla biome IDs can be found here: http://goo.gl/WqlAfV" + Configuration.NEW_LINE + "For modded biome IDs, use NEI and go [Options] > [Tools] > [Data Dumps] > Biomes > [Dump], and then refer to the 'biome.csv' file which can be found in your '/.minecraft/dumps' folder." + Configuration.NEW_LINE);
            biomeSize = config.getInt("Size of Biomes", "Biomes", biomeSize, 1, 20, "Lower values = smaller biomes; Higher values = larger biomes" + Configuration.NEW_LINE + "1 = Tiny biomes; 2 = Small biomes; 3 = Normal biomes; 4 = Large biomes; 5 = Huge biomes" + Configuration.NEW_LINE + "Values greater than 5 are not recommended. Use at your own risk." + Configuration.NEW_LINE);
            enableCobblestoneBoulders = config.getBoolean("Enable Cobblestone Boulders", "Boulders", enableCobblestoneBoulders, "");
            cobblestoneBoulderChance = config.getInt("1/x chance that Cobblestone Boulders will generate if given the opportunity to do so during world gen", "Boulders", cobblestoneBoulderChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableCaves = config.getBoolean("Enable Caves", "Caves", enableCaves, "");
            caveDensity = config.getInt("Cave Density", "Caves", caveDensity, 1, 40, "This setting controls the size of caves." + Configuration.NEW_LINE + "HIGHER values = BIGGER caves & MORE lag. (14 = vanilla cave density)" + Configuration.NEW_LINE);
            caveFrequency = config.getInt("Cave Frequency", "Caves", caveFrequency, 1, 40, "This setting controls the number of caves that generate." + Configuration.NEW_LINE + "LOWER values = MORE caves & MORE lag. (6 = vanilla cave frequency)" + Configuration.NEW_LINE);
            duneHeight = config.getInt("Height of Dunes", "Dunes", duneHeight, 1, 12, "This setting controls the height of both sand dunes and snow dunes." + Configuration.NEW_LINE + "Higher values = taller dunes." + Configuration.NEW_LINE);
            showDebugInfo = config.getBoolean("Show Debug Info in F3 Screen", "Debugging", showDebugInfo, "");
            enableDebugging = config.getBoolean("Enable Debugging", "Debugging", enableDebugging, "WARNING: This should only be enabled if you know what you're doing." + Configuration.NEW_LINE);
            generateDungeons = config.getBoolean("Generate Dungeons", "Dungeons", generateDungeons, "");
            enableWaterSurfaceLakes = config.getBoolean("Enable Water Surface Lakes", "Lakes (Surface)", enableWaterSurfaceLakes, "");
            waterSurfaceLakeChance = config.getInt("1/x chance that Water Surface Lakes will generate if given the opportunity to do so during world gen", "Lakes (Surface)", waterSurfaceLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableLavaSurfaceLakes = config.getBoolean("Enable Lava Surface Lakes", "Lakes (Surface)", enableLavaSurfaceLakes, "");
            lavaSurfaceLakeChance = config.getInt("1/x chance that Lava Surface Lakes will generate if given the opportunity to do so during world gen", "Lakes (Surface)", lavaSurfaceLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableWaterUndergroundLakes = config.getBoolean("Enable Water Underground Lakes", "Lakes (Underground)", enableWaterUndergroundLakes, "");
            waterUndergroundLakeChance = config.getInt("1/x chance that Water Underground Lakes will generate if given the opportunity to do so during world gen", "Lakes (Underground)", waterUndergroundLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableLavaUndergroundLakes = config.getBoolean("Enable Lava Underground Lakes", "Lakes (Underground)", enableLavaUndergroundLakes, "");
            lavaUndergroundLakeChance = config.getInt("1/x chance that Lava Underground Lakes will generate if given the opportunity to do so during world gen", "Lakes (Underground)", lavaUndergroundLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            generateMineshafts = config.getBoolean("Generate Mineshafts", "Mineshafts", generateMineshafts, "");
            generateOreCoal = config.getBoolean("Generate Coal Ore", "Ore Gen", generateOreCoal, "");
            generateOreIron = config.getBoolean("Generate Iron Ore", "Ore Gen", generateOreIron, "");
            generateOreGold = config.getBoolean("Generate Gold Ore", "Ore Gen", generateOreGold, "");
            generateOreRedstone = config.getBoolean("Generate Redstone Ore", "Ore Gen", generateOreRedstone, "");
            generateOreLapis = config.getBoolean("Generate Lapis Lazuli Ore", "Ore Gen", generateOreLapis, "");
            generateOreDiamond = config.getBoolean("Generate Diamond Ore", "Ore Gen", generateOreDiamond, "");
            generateOreEmerald = config.getBoolean("Generate Emerald Ore", "Ore Gen", generateOreEmerald, "");
            generateScatteredFeatures = config.getBoolean("Generate Scattered Features", "Scattered Features", generateScatteredFeatures, "");
            minDistanceScatteredFeatures = config.getInt("Minimum distance between scattered features", "Scattered Features", minDistanceScatteredFeatures, 1, Integer.MAX_VALUE, "Scattered features = desert temples, jungle temples, and witch huts." + Configuration.NEW_LINE);
            maxDistanceScatteredFeatures = config.getInt("Maximum distance between scattered features", "Scattered Features", maxDistanceScatteredFeatures, 1, Integer.MAX_VALUE, "Scattered features = desert temples, jungle temples, and witch huts." + Configuration.NEW_LINE);
            enableSnowLayers = config.getBoolean("Enable Snow Layers", "Snow", enableSnowLayers, "This applies to newly-generated chunks only. Snow layers will still appear in cold/snowy biomes after it snows." + Configuration.NEW_LINE);
            generateStrongholds = config.getBoolean("Generate Strongholds", "Strongholds", generateStrongholds, "");
            shadowStoneBlockId = config.getString("Stone shadow block ID", "Terrain shadowing", shadowStoneBlockId, "The block to use for stone terrain shadowing, typically seen on the cliffs of stone mountains. Defaults to stained hardened clay." + Configuration.NEW_LINE);
            shadowStoneBlockByte = config.getInt("Stone shadow block meta value", "Terrain shadowing", shadowStoneBlockByte, 0, 15, "The meta value of the shadow block for stone cliffs. Defaults to " + shadowStoneBlockByte + " (cyan)." + Configuration.NEW_LINE);
            shadowDesertBlockId = config.getString("Desert shadow block ID", "Terrain shadowing", shadowDesertBlockId, "The block to use for desert terrain shadowing, typically seen on the cliffs of desert mountains. Defaults to stained hardened clay." + Configuration.NEW_LINE);
            shadowDesertBlockByte = config.getInt("Desert shadow block meta value", "Terrain shadowing", shadowDesertBlockByte, 0, 15, "The meta value of the shadow block for desert cliffs. Defaults to " + shadowDesertBlockByte + " (light gray)." + Configuration.NEW_LINE);
            enableUBCStoneShadowing = config.getBoolean("UBC Mode (Stone)", "Terrain shadowing", enableUBCStoneShadowing, "Set this to TRUE to allow UBC to override stone shadowing." + Configuration.NEW_LINE + "This setting doesn't have any effect if UBC is not installed." + Configuration.NEW_LINE);
            enableUBCDesertShadowing = config.getBoolean("UBC Mode (Desert)", "Terrain shadowing", enableUBCDesertShadowing, "Set this to TRUE to allow UBC to override desert shadowing." + Configuration.NEW_LINE + "This setting doesn't have any effect if UBC is not installed." + Configuration.NEW_LINE);
            enableVillageModifications = config.getBoolean("Enable village modifications", "Villages", enableVillageModifications, "Set this to FALSE to resolve issues with mods that also modify villages." + Configuration.NEW_LINE + "If set to FALSE, the 'Minimum distance between villages', 'Maximum distance between villages' & 'Size of villages' settings will have no effect." + Configuration.NEW_LINE);
            generateVillages = config.getBoolean("Generate Villages", "Villages", generateVillages, "");
            villageSize = config.getInt("Size of villages", "Villages", villageSize, 0, 10, "Higher values = bigger villages; 0 = Vanilla" + Configuration.NEW_LINE);
            minDistanceVillages = config.getInt("Minimum distance between villages", "Villages", minDistanceVillages, 1, Integer.MAX_VALUE, "Higher values = villages further apart; 8 = Vanilla" + Configuration.NEW_LINE);
            maxDistanceVillages = config.getInt("Maximum distance between villages", "Villages", maxDistanceVillages, 1, Integer.MAX_VALUE, "Lower values = villages closer together; 32 = Vanilla" + Configuration.NEW_LINE);
            volcanoBlockId = config.getString("Volcano block ID", "Volcanoes", volcanoBlockId, "The block to use for the top of the volcano. Defaults to Obsidian." + Configuration.NEW_LINE);
            volcanoBlockByte = config.getInt("Volcano block meta value", "Volcanoes", volcanoBlockByte, 0, 15, "The meta value of the volcano block." + Configuration.NEW_LINE);
            enableVolcanoEruptions = config.getBoolean("Enable volcano eruptions", "Volcanoes", enableVolcanoEruptions, "Set this to FALSE to prevent lava from flowing down the sides of volcanoes." + Configuration.NEW_LINE);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading RTG configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static boolean enableVillageTweaks() {
        boolean enableVillageModifications = true;
        return enableVillageModifications;
    }

    static {
        generateOnlyThisBiomeId = -1;
        enableUBCStoneShadowing = true;
        enableUBCDesertShadowing = true;
        shadowStoneBlockId = "minecraft:stained_hardened_clay";
        shadowStoneBlockByte = 9;
        shadowDesertBlockId = "minecraft:stained_hardened_clay";
        shadowDesertBlockByte = 8;
        bedrockBlockId = "minecraft:bedrock";
        bedrockBlockByte = 0;
        duneHeight = 4;
        volcanoBlockId = "minecraft:obsidian";
        volcanoBlockByte = 0;
        enableVolcanoEruptions = true;
        generateOreCoal = true;
        generateOreIron = true;
        generateOreGold = true;
        generateOreRedstone = true;
        generateOreLapis = true;
        generateOreDiamond = true;
        generateOreEmerald = true;
        enableCobblestoneBoulders = true;
        cobblestoneBoulderChance = 1;
        enableWaterSurfaceLakes = true;
        waterSurfaceLakeChance = 10;
        enableWaterUndergroundLakes = true;
        waterUndergroundLakeChance = 10;
        enableLavaSurfaceLakes = true;
        lavaSurfaceLakeChance = 10;
        enableLavaUndergroundLakes = true;
        lavaUndergroundLakeChance = 10;
        generateMineshafts = true;
        generateStrongholds = true;
        generateVillages = true;
        generateScatteredFeatures = true;
        generateDungeons = true;
        enableCaves = true;
        caveDensity = 8;
        caveFrequency = 16;
        enableSnowLayers = true;
        flatBedrockLayers = 0;
        showDebugInfo = false;
        enableDebugging = false;
        biomeSize = 3;
        minDistanceScatteredFeatures = 16;
        maxDistanceScatteredFeatures = 64;
        enableVillageModifications = ConfigRTG.enableVillageTweaks();
        villageSize = 0;
        minDistanceVillages = 16;
        maxDistanceVillages = 64;
    }
}

