/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.chromaticraft;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ConfigCC {
    public static Configuration config;
    public static final int biomeWeightMin = 0;
    public static final int biomeWeightMax = 100;
    public static final int biomeWeightDefault = 10;
    public static boolean generateCCBiomes;
    public static boolean generateCCEnderForest;
    public static boolean generateCCRainbowForest;
    public static int weightCCEnderForest;
    public static int weightCCRainbowForest;
    public static boolean villageCCEnderForest;
    public static boolean villageCCRainbowForest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            generateCCBiomes = config.getBoolean("Allow biomes from this mod to generate", "Allow mod biomes", true, "If TRUE, uses the individual biome settings below. If FALSE, disables all biomes from this mod." + Configuration.NEW_LINE);
            generateCCEnderForest = config.getBoolean(ConfigCC.formatConfig("generateCCEnderForest"), "Biomes", generateCCEnderForest, "");
            generateCCRainbowForest = config.getBoolean(ConfigCC.formatConfig("generateCCRainbowForest"), "Biomes", generateCCRainbowForest, "");
            weightCCEnderForest = config.getInt(ConfigCC.formatConfig("weightCCEnderForest"), "Weights", weightCCEnderForest, 0, 100, "");
            weightCCRainbowForest = config.getInt(ConfigCC.formatConfig("weightCCRainbowForest"), "Weights", weightCCRainbowForest, 0, 100, "");
            villageCCEnderForest = config.getBoolean(ConfigCC.formatConfig("villageCCEnderForest"), "Villages", villageCCEnderForest, "");
            villageCCRainbowForest = config.getBoolean(ConfigCC.formatConfig("villageCCRainbowForest"), "Villages", villageCCRainbowForest, "");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading ChromatiCraft configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String formatConfig(String s) {
        String returnString = s;
        returnString = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)returnString), (String)" ");
        if (s.startsWith("generate")) {
            returnString = StringUtils.replace((String)returnString, (String)"generate", (String)"Generate", (int)1);
        } else if (s.startsWith("village")) {
            returnString = StringUtils.replace((String)returnString, (String)"village", (String)"Allow villages to generate in", (int)1);
        } else if (s.startsWith("weight")) {
            returnString = StringUtils.replace((String)returnString, (String)"weight", (String)"Weight of", (int)1);
        }
        return returnString;
    }

    static {
        generateCCBiomes = true;
        generateCCEnderForest = true;
        generateCCRainbowForest = true;
        weightCCEnderForest = 10;
        weightCCRainbowForest = 10;
        villageCCEnderForest = false;
        villageCCRainbowForest = false;
    }
}

