/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.buildcraft;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ConfigBC {
    public static Configuration config;
    public static final int biomeWeightMin = 0;
    public static final int biomeWeightMax = 100;
    public static final int biomeWeightDefault = 10;
    public static boolean generateBCBiomes;
    public static boolean generateBCDesertOilField;
    public static boolean generateBCOceanOilField;
    public static int weightBCDesertOilField;
    public static int weightBCOceanOilField;
    public static boolean villageBCDesertOilField;
    public static boolean villageBCOceanOilField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            generateBCBiomes = config.getBoolean("Allow biomes from this mod to generate", "Allow mod biomes", generateBCBiomes, "If TRUE, uses the individual biome settings below. If FALSE, disables all biomes from this mod." + Configuration.NEW_LINE);
            generateBCDesertOilField = config.getBoolean(ConfigBC.formatConfig("generateBCDesertOilField"), "Biomes", generateBCDesertOilField, "");
            generateBCOceanOilField = config.getBoolean(ConfigBC.formatConfig("generateBCOceanOilField"), "Biomes", generateBCOceanOilField, "");
            weightBCDesertOilField = config.getInt(ConfigBC.formatConfig("weightBCDesertOilField"), "Weights", weightBCDesertOilField, 0, 100, "");
            weightBCOceanOilField = config.getInt(ConfigBC.formatConfig("weightBCOceanOilField"), "Weights", weightBCOceanOilField, 0, 100, "");
            villageBCDesertOilField = config.getBoolean(ConfigBC.formatConfig("villageBCDesertOilField"), "Villages", villageBCDesertOilField, "");
            villageBCOceanOilField = config.getBoolean(ConfigBC.formatConfig("villageBCOceanOilField"), "Villages", villageBCOceanOilField, "");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading BuildCraft configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String formatConfig(String s) {
        String returnString = s;
        returnString = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)returnString), (String)" ");
        if (s.startsWith("generate")) {
            returnString = StringUtils.replace((String)returnString, (String)"generate", (String)"Generate", (int)1);
        } else if (s.startsWith("village")) {
            returnString = StringUtils.replace((String)returnString, (String)"village", (String)"Allow villages to generate in", (int)1);
        } else if (s.startsWith("weight")) {
            returnString = StringUtils.replace((String)returnString, (String)"weight", (String)"Weight of", (int)1);
        }
        return returnString;
    }

    static {
        generateBCBiomes = true;
        generateBCDesertOilField = true;
        generateBCOceanOilField = true;
        weightBCDesertOilField = (int)Math.floor(1.0);
        weightBCOceanOilField = (int)Math.floor(1.0);
        villageBCDesertOilField = false;
        villageBCOceanOilField = false;
    }
}

