/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.atg;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ConfigATG {
    public static Configuration config;
    public static final int biomeWeightMin = 0;
    public static final int biomeWeightMax = 100;
    public static final int biomeWeightDefault = 10;
    public static boolean generateATGBiomes;
    public static boolean generateATGGravelBeach;
    public static boolean generateATGSnowyGravelBeach;
    public static boolean generateATGShrubland;
    public static boolean generateATGRockySteppe;
    public static boolean generateATGTropicalShrubland;
    public static boolean generateATGTundra;
    public static boolean generateATGVolcano;
    public static boolean generateATGWoodland;
    public static int weightATGGravelBeach;
    public static int weightATGSnowyGravelBeach;
    public static int weightATGShrubland;
    public static int weightATGRockySteppe;
    public static int weightATGTropicalShrubland;
    public static int weightATGTundra;
    public static int weightATGVolcano;
    public static int weightATGWoodland;
    public static boolean villageATGGravelBeach;
    public static boolean villageATGSnowyGravelBeach;
    public static boolean villageATGShrubland;
    public static boolean villageATGRockySteppe;
    public static boolean villageATGTropicalShrubland;
    public static boolean villageATGTundra;
    public static boolean villageATGVolcano;
    public static boolean villageATGWoodland;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            generateATGBiomes = config.getBoolean("Allow biomes from this mod to generate", "Allow mod biomes", generateATGBiomes, "If TRUE, uses the individual biome settings below. If FALSE, disables all biomes from this mod." + Configuration.NEW_LINE);
            generateATGGravelBeach = config.getBoolean(ConfigATG.formatConfig("generateATGGravelBeach"), "Biomes", generateATGGravelBeach, "");
            generateATGSnowyGravelBeach = config.getBoolean(ConfigATG.formatConfig("generateATGSnowyGravelBeach"), "Biomes", generateATGSnowyGravelBeach, "");
            generateATGShrubland = config.getBoolean(ConfigATG.formatConfig("generateATGShrubland"), "Biomes", generateATGShrubland, "");
            generateATGRockySteppe = config.getBoolean(ConfigATG.formatConfig("generateATGRockySteppe"), "Biomes", generateATGRockySteppe, "");
            generateATGTropicalShrubland = config.getBoolean(ConfigATG.formatConfig("generateATGTropicalShrubland"), "Biomes", generateATGTropicalShrubland, "");
            generateATGTundra = config.getBoolean(ConfigATG.formatConfig("generateATGTundra"), "Biomes", generateATGTundra, "");
            generateATGVolcano = config.getBoolean(ConfigATG.formatConfig("generateATGVolcano"), "Biomes", generateATGVolcano, "");
            generateATGWoodland = config.getBoolean(ConfigATG.formatConfig("generateATGWoodland"), "Biomes", generateATGWoodland, "");
            weightATGGravelBeach = config.getInt(ConfigATG.formatConfig("weightATGGravelBeach"), "Weights", weightATGGravelBeach, 0, 100, "");
            weightATGSnowyGravelBeach = config.getInt(ConfigATG.formatConfig("weightATGSnowyGravelBeach"), "Weights", weightATGSnowyGravelBeach, 0, 100, "");
            weightATGShrubland = config.getInt(ConfigATG.formatConfig("weightATGShrubland"), "Weights", weightATGShrubland, 0, 100, "");
            weightATGRockySteppe = config.getInt(ConfigATG.formatConfig("weightATGRockySteppe"), "Weights", weightATGRockySteppe, 0, 100, "");
            weightATGTropicalShrubland = config.getInt(ConfigATG.formatConfig("weightATGTropicalShrubland"), "Weights", weightATGTropicalShrubland, 0, 100, "");
            weightATGTundra = config.getInt(ConfigATG.formatConfig("weightATGTundra"), "Weights", weightATGTundra, 0, 100, "");
            weightATGVolcano = config.getInt(ConfigATG.formatConfig("weightATGVolcano"), "Weights", weightATGVolcano, 0, 100, "");
            weightATGWoodland = config.getInt(ConfigATG.formatConfig("weightATGWoodland"), "Weights", weightATGWoodland, 0, 100, "");
            villageATGGravelBeach = config.getBoolean(ConfigATG.formatConfig("villageATGGravelBeach"), "Villages", villageATGGravelBeach, "");
            villageATGSnowyGravelBeach = config.getBoolean(ConfigATG.formatConfig("villageATGSnowyGravelBeach"), "Villages", villageATGSnowyGravelBeach, "");
            villageATGShrubland = config.getBoolean(ConfigATG.formatConfig("villageATGShrubland"), "Villages", villageATGShrubland, "");
            villageATGRockySteppe = config.getBoolean(ConfigATG.formatConfig("villageATGRockySteppe"), "Villages", villageATGRockySteppe, "");
            villageATGTropicalShrubland = config.getBoolean(ConfigATG.formatConfig("villageATGTropicalShrubland"), "Villages", villageATGTropicalShrubland, "");
            villageATGTundra = config.getBoolean(ConfigATG.formatConfig("villageATGTundra"), "Villages", villageATGTundra, "");
            villageATGVolcano = config.getBoolean(ConfigATG.formatConfig("villageATGVolcano"), "Villages", villageATGVolcano, "");
            villageATGWoodland = config.getBoolean(ConfigATG.formatConfig("villageATGWoodland"), "Villages", villageATGWoodland, "");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading ATG configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String formatConfig(String s) {
        String returnString = s;
        returnString = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)returnString), (String)" ");
        if (s.startsWith("generate")) {
            returnString = StringUtils.replace((String)returnString, (String)"generate", (String)"Generate", (int)1);
        } else if (s.startsWith("village")) {
            returnString = StringUtils.replace((String)returnString, (String)"village", (String)"Allow villages to generate in", (int)1);
        } else if (s.startsWith("weight")) {
            returnString = StringUtils.replace((String)returnString, (String)"weight", (String)"Weight of", (int)1);
        }
        return returnString;
    }

    static {
        generateATGBiomes = true;
        generateATGGravelBeach = true;
        generateATGSnowyGravelBeach = true;
        generateATGShrubland = true;
        generateATGRockySteppe = true;
        generateATGTropicalShrubland = true;
        generateATGTundra = true;
        generateATGVolcano = false;
        generateATGWoodland = true;
        weightATGGravelBeach = (int)Math.floor(5.0);
        weightATGSnowyGravelBeach = (int)Math.floor(5.0);
        weightATGShrubland = 10;
        weightATGRockySteppe = 10;
        weightATGTropicalShrubland = 10;
        weightATGTundra = 10;
        weightATGVolcano = (int)Math.floor(1.0);
        weightATGWoodland = 10;
        villageATGGravelBeach = false;
        villageATGSnowyGravelBeach = false;
        villageATGShrubland = true;
        villageATGRockySteppe = true;
        villageATGTropicalShrubland = true;
        villageATGTundra = true;
        villageATGVolcano = false;
        villageATGWoodland = true;
    }
}

