/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.arsmagica;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class ConfigAM {
    public static Configuration config;
    public static final int biomeWeightMin = 0;
    public static final int biomeWeightMax = 100;
    public static final int biomeWeightDefault = 10;
    public static boolean generateAMBiomes;
    public static boolean generateAMWitchwoodForest;
    public static int weightAMWitchwoodForest;
    public static boolean villageAMWitchwoodForest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            generateAMBiomes = config.getBoolean("Allow biomes from this mod to generate", "Allow mod biomes", generateAMBiomes, "If TRUE, uses the individual biome settings below. If FALSE, disables all biomes from this mod." + Configuration.NEW_LINE);
            generateAMWitchwoodForest = config.getBoolean(ConfigAM.formatConfig("generateAMWitchwoodForest"), "Biomes", generateAMWitchwoodForest, "");
            weightAMWitchwoodForest = config.getInt(ConfigAM.formatConfig("weightAMWitchwoodForest"), "Weights", weightAMWitchwoodForest, 0, 100, "");
            villageAMWitchwoodForest = config.getBoolean(ConfigAM.formatConfig("villageAMWitchwoodForest"), "Villages", villageAMWitchwoodForest, "");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RTG has had a problem loading AM configuration.", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String formatConfig(String s) {
        String returnString = s;
        returnString = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)returnString), (String)" ");
        if (s.startsWith("generate")) {
            returnString = StringUtils.replace((String)returnString, (String)"generate", (String)"Generate", (int)1);
        } else if (s.startsWith("village")) {
            returnString = StringUtils.replace((String)returnString, (String)"village", (String)"Allow villages to generate in", (int)1);
        } else if (s.startsWith("weight")) {
            returnString = StringUtils.replace((String)returnString, (String)"weight", (String)"Weight of", (int)1);
        }
        return returnString;
    }

    static {
        generateAMBiomes = true;
        generateAMWitchwoodForest = true;
        weightAMWitchwoodForest = (int)Math.floor(15.0);
        villageAMWitchwoodForest = false;
    }
}

