/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.util.singletons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import net.minecraftforge.common.DimensionManager;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.util.BoundItemState;

public class BoundItems {
    private static final String fileName = String.valueOf(DimensionManager.getCurrentSaveRootDirectory()) + "/" + "sanguimancy" + "/BoundItems.dat";
    private static BoundItems boundItems;
    private HashMap<String, BoundItemState> items;

    private BoundItems() {
    }

    public static BoundItems getBoundItems() {
        if (boundItems == null) {
            boundItems = new BoundItems();
            boundItems.loadFile();
        }
        if (BoundItems.boundItems.items == null) {
            BoundItems.boundItems.items = new HashMap();
            boundItems.updateFile();
        }
        return boundItems;
    }

    private void loadFile() {
        HashMap map = null;
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                if (file.getParentFile().mkdir()) {
                    if (file.createNewFile()) {
                        Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                    }
                } else if (file.createNewFile()) {
                    Sanguimancy.logger.info("Creating " + fileName + " in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
                } else {
                    throw new IOException("Failed to create directory " + file.getParent());
                }
            }
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            map = (HashMap)in.readObject();
            in.close();
            fileIn.close();
            this.items = map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Sanguimancy.logger.error(String.valueOf(file) + " was not found in " + String.valueOf(DimensionManager.getCurrentSaveRootDirectory()));
        }
    }

    private void updateFile() {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.items);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean addItem(String name, BoundItemState location) {
        if (!this.items.isEmpty() && this.items.get(name) != null) {
            Sanguimancy.logger.info("Location " + name + " already exists.");
            this.updateFile();
            return false;
        }
        this.items.put(name, location);
        Sanguimancy.logger.info("Adding " + name);
        this.updateFile();
        return true;
    }

    public boolean removeItem(String name) {
        if (this.items.get(name) != null && !this.items.isEmpty()) {
            if (this.items.containsKey(name)) {
                this.items.remove(name);
                Sanguimancy.logger.info("Removing " + name);
                this.updateFile();
                return true;
            }
            Sanguimancy.logger.info("No location matching " + name);
            this.updateFile();
            return false;
        }
        return false;
    }

    public boolean hasKey(String name) {
        return this.items.containsKey(name);
    }

    public BoundItemState getLinkedLocation(String name) {
        return this.items.get(name);
    }
}

