/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.tile;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tombenpotter.sanguimancy.api.tile.TileBaseSidedInventory;
import tombenpotter.sanguimancy.recipes.RecipeBloodCleanser;

public class TileBloodCleaner
extends TileBaseSidedInventory
implements IFluidHandler {
    public int capacity;
    public int ticksLeft;
    public int maxTicks;
    public FluidTank tank;
    public boolean isActive;

    public TileBloodCleaner() {
        this.slots = new ItemStack[2];
        this.capacity = 16000;
        this.maxTicks = 150;
        this.tank = new FluidTank(new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0), this.capacity);
        this.isActive = false;
        this.customNBTTag = new NBTTagCompound();
    }

    public void func_145845_h() {
        if (this.func_70301_a(0) != null && this.canBloodClean()) {
            if (this.ticksLeft >= this.maxTicks) {
                this.bloodClean();
                this.ticksLeft = 0;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                ++this.ticksLeft;
            }
            this.isActive = true;
        } else {
            this.ticksLeft = 0;
            this.isActive = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void bloodClean() {
        if (this.canBloodClean()) {
            ItemStack ouput = RecipeBloodCleanser.getRecipe((ItemStack)this.func_70301_a((int)0)).fOutput.func_77946_l();
            if (this.func_70301_a(1) == null) {
                this.func_70299_a(1, ouput);
            } else if (this.func_70301_a(1).func_77969_a(RecipeBloodCleanser.getRecipe((ItemStack)this.func_70301_a((int)0)).fOutput.func_77946_l())) {
                this.func_70301_a((int)1).field_77994_a += ouput.field_77994_a;
            }
            this.func_70298_a(0, RecipeBloodCleanser.getRecipe((ItemStack)this.func_70301_a((int)0)).fInput.field_77994_a);
            this.drain(ForgeDirection.UNKNOWN, 1000, true);
        }
    }

    public boolean canBloodClean() {
        if (this.func_70301_a(0) == null) {
            return false;
        }
        ItemStack input = this.func_70301_a(0);
        if (!RecipeBloodCleanser.isRecipeValid(input)) {
            return false;
        }
        if (this.tank.getFluid() == null) {
            return false;
        }
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        RecipeBloodCleanser recipe = RecipeBloodCleanser.getRecipe(input);
        ItemStack output = recipe.fOutput.func_77946_l();
        if (this.func_70301_a(1) == null) {
            return true;
        }
        if (!this.func_70301_a(1).func_77969_a(output)) {
            return false;
        }
        if (this.tank.getFluid().amount < 1000) {
            return false;
        }
        int result = this.func_70301_a((int)1).field_77994_a + output.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.func_70301_a(1).func_77976_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ticksLeft = tagCompound.func_74762_e("ticksLeft");
        this.isActive = tagCompound.func_74767_n("isActive");
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("ticksLeft", this.ticksLeft);
        tagCompound.func_74757_a("isActive", this.isActive);
        this.tank.writeToNBT(tagCompound);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluidID() == AlchemicalWizardry.lifeEssenceFluid.getID()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.tank.drain(maxEmpty, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid().isFluidEqual(new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0 && this.func_94041_b(0, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public String func_145825_b() {
        return "Lump Cleaner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int[] func_94128_d(int var1) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)var1);
        switch (dir) {
            case DOWN: 
            case UP: 
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return new int[]{0, 1};
            }
        }
        return new int[0];
    }
}

