/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.tile;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tombenpotter.sanguimancy.api.tile.TileBaseSidedInventory;

public class TileAltarManipulator
extends TileBaseSidedInventory {
    public int sideToOutput;

    public TileAltarManipulator() {
        this.slots = new ItemStack[3];
        this.customNBTTag = new NBTTagCompound();
        this.sideToOutput = 0;
    }

    public String func_145825_b() {
        return "Altar Manipulator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != null && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TEAltar) {
            TEAltar altar = (TEAltar)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (this.func_70301_a(1) != null) {
                this.outputToAdjacentInventory();
            }
            if (altar.func_70301_a(0) != null) {
                this.moveItemsFromAltar(altar);
            }
            if (this.func_70301_a(0) != null) {
                this.insertItemInAltar(altar);
            }
        }
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != null && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TEAltar) {
            TEAltar altar = (TEAltar)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            return slot == 0 && this.canInsertItemInAltar(altar, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean canInsertItemInAltar(TEAltar altar, ItemStack stack) {
        int tier;
        if (stack != null && altar != null && AltarRecipeRegistry.isRequiredItemValid((ItemStack)stack, (int)(tier = altar.getTier()))) {
            int containedBlood = altar.getCurrentBlood();
            AltarRecipe recipe = AltarRecipeRegistry.getAltarRecipeForItemAndTier((ItemStack)stack, (int)tier);
            int bloodRequired = recipe.liquidRequired;
            if (altar.func_70301_a(0) == null && bloodRequired * stack.field_77994_a <= containedBlood) {
                return true;
            }
            if (altar.func_70301_a(0) != null && altar.func_70301_a(0).func_77969_a(stack) && altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a <= altar.func_70297_j_() && altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a <= stack.func_77976_d() && (altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a) * bloodRequired <= containedBlood) {
                return true;
            }
        }
        return false;
    }

    public void insertItemInAltar(TEAltar altar) {
        int tier;
        ItemStack stack = this.func_70301_a(0).func_77946_l();
        if (AltarRecipeRegistry.isRequiredItemValid((ItemStack)stack, (int)(tier = altar.getTier()))) {
            int containedBlood = altar.getCurrentBlood();
            AltarRecipe recipe = AltarRecipeRegistry.getAltarRecipeForItemAndTier((ItemStack)stack, (int)tier);
            int bloodRequired = recipe.liquidRequired;
            if (altar.func_70301_a(0) == null) {
                if (bloodRequired * stack.field_77994_a <= containedBlood) {
                    altar.func_70299_a(0, stack);
                    this.func_70299_a(0, null);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    altar.startCycle();
                }
            } else if (altar.func_70301_a(0) != null && altar.func_70301_a(0).func_77969_a(stack) && altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a <= altar.func_70297_j_() && altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a <= stack.func_77976_d() && (altar.func_70301_a((int)0).field_77994_a + stack.field_77994_a) * bloodRequired <= containedBlood) {
                int s1 = altar.func_70301_a((int)0).field_77994_a;
                altar.func_70301_a((int)0).field_77994_a = s1 + stack.field_77994_a;
                this.func_70299_a(0, null);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147471_g(altar.field_145851_c, altar.field_145848_d, altar.field_145849_e);
            }
        }
    }

    public void moveItemsFromAltar(TEAltar altar) {
        ItemStack stack = altar.func_70301_a(0).func_77946_l();
        if (altar.getProgress() <= 0) {
            if (this.func_70301_a(1) == null) {
                this.func_70299_a(1, stack);
                altar.func_70299_a(0, null);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147471_g(altar.field_145851_c, altar.field_145848_d, altar.field_145849_e);
            } else if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77969_a(stack) && this.func_70301_a((int)1).field_77994_a + stack.field_77994_a <= stack.func_77976_d()) {
                this.func_70301_a((int)1).field_77994_a += stack.field_77994_a;
                altar.func_70299_a(0, null);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147471_g(altar.field_145851_c, altar.field_145848_d, altar.field_145849_e);
            }
        }
    }

    public void outputToAdjacentInventory() {
        TileEntity tile;
        ItemStack stack = this.func_70301_a(1).func_77946_l();
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.sideToOutput);
        if (dir != ForgeDirection.DOWN && (tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) != null && tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            if (inventory.func_70302_i_() <= 0) {
                return;
            }
            SpellHelper.insertStackIntoInventory((ItemStack)stack, (IInventory)inventory, (ForgeDirection)ForgeDirection.UNKNOWN);
            this.func_70299_a(1, null);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.sideToOutput = tagCompound.func_74762_e("sideToOutput");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("sideToOutput", this.sideToOutput);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1};
    }
}

