/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.rituals;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualBreakMethod;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RitualEffectQuarry
extends RitualEffect {
    public static final int reagentDrain = 1000;

    public boolean startRitual(IMasterRitualStone ritualStone, EntityPlayer player) {
        int z;
        int y;
        int x;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
        World world = ritualStone.getWorld();
        TileEntity tile = world.func_147438_o(x = ritualStone.getXCoord(), (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory)) {
            return false;
        }
        IInventory tileEntity = (IInventory)tile;
        if (tileEntity.func_70302_i_() <= 0) {
            return false;
        }
        boolean hasRoom = false;
        for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
            if (tileEntity.func_70301_a(i) != null) continue;
            hasRoom = true;
            break;
        }
        if (!hasRoom) {
            return false;
        }
        boolean hasCrystallos = this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 1000, false);
        boolean hasIncendium = this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 1000, false);
        boolean hasTenebrae = this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 1000, false);
        boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 1000, true);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 1000, true);
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
        } else {
            for (int i = 0; i < 6; ++i) {
                SpellHelper.sendIndexedParticleToAllAround((World)world, (double)x, (double)y, (double)z, (int)20, (int)world.field_73011_w.field_76574_g, (int)3, (double)x, (double)y, (double)z);
            }
        }
        return true;
    }

    public void performEffect(IMasterRitualStone ritualStone) {
        this.onRitualBroken(ritualStone, RitualBreakMethod.DEACTIVATE);
    }

    public int getCostPerRefresh() {
        return 300;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> quarryRitual = new ArrayList<RitualComponent>();
        quarryRitual.add(new RitualComponent(1, 0, 1, 3));
        quarryRitual.add(new RitualComponent(-1, 0, 1, 3));
        quarryRitual.add(new RitualComponent(1, 0, -1, 3));
        quarryRitual.add(new RitualComponent(-1, 0, -1, 3));
        quarryRitual.add(new RitualComponent(2, 0, 0, 3));
        quarryRitual.add(new RitualComponent(-2, 0, 0, 3));
        quarryRitual.add(new RitualComponent(0, 0, -2, 3));
        quarryRitual.add(new RitualComponent(0, 0, 2, 3));
        quarryRitual.add(new RitualComponent(1, 2, 1, 5));
        quarryRitual.add(new RitualComponent(-1, 2, 1, 5));
        quarryRitual.add(new RitualComponent(1, 2, -1, 5));
        quarryRitual.add(new RitualComponent(-1, 2, -1, 5));
        quarryRitual.add(new RitualComponent(2, 2, 0, 5));
        quarryRitual.add(new RitualComponent(-2, 2, 0, 5));
        quarryRitual.add(new RitualComponent(0, 2, -2, 5));
        quarryRitual.add(new RitualComponent(0, 2, 2, 5));
        return quarryRitual;
    }
}

