/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.items.corrupted;

import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.objects.MapKey;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruptionHelper;
import tombenpotter.sanguimancy.util.ConfigHandler;
import tombenpotter.sanguimancy.util.RandomUtils;

public class ItemCorruptedAxe
extends ItemAxe {
    public int minimumCorruption = ConfigHandler.minimumToolCorruption;
    public IIcon leafDecay;
    public IIcon headHunter;
    public IIcon refine;

    public ItemCorruptedAxe(Item.ToolMaterial material) {
        super(material);
        this.func_77637_a(Sanguimancy.tabSanguimancy);
        this.func_77655_b("Sanguimancy.corruptedAxe");
        this.func_77656_e(0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("sanguimancy:CorruptedAxe");
        this.leafDecay = ir.func_94245_a("sanguimancy:CorruptedAxe_LeafDecay");
        this.headHunter = ir.func_94245_a("sanguimancy:CorruptedAxe_HeadHunter");
        this.refine = ir.func_94245_a("sanguimancy:CorruptedAxe_Refine");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (this.getToolMode(stack) == 1) {
            return this.leafDecay;
        }
        if (this.getToolMode(stack) == 2) {
            return this.headHunter;
        }
        if (this.getToolMode(stack) == 3) {
            return this.refine;
        }
        return this.field_77791_bV;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entityLivingBase) {
        if (block.func_149712_f(world, x, y, z) >= 0.0f) {
            RandomUtils.checkAndSetCompound(stack);
            int toolMode = this.getToolMode(stack);
            int metadata = world.func_72805_g(x, y, z);
            int lpConsumption = 10;
            if (toolMode == 0) {
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 1) {
                lpConsumption *= 5;
                for (int i = x - 5; i <= x + 5; ++i) {
                    for (int j = y - 5; j <= y + 5; ++j) {
                        for (int k = z - 5; k <= z + 5; ++k) {
                            if (!(world.func_147439_a(i, j, k) instanceof BlockLeavesBase)) continue;
                            world.func_147468_f(i, j, k);
                        }
                    }
                }
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 2) {
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 3) {
                ItemStack drops;
                lpConsumption *= 10;
                if (!RandomUtils.getItemStackName(new ItemStack(block)).isEmpty() && RandomUtils.getItemStackName(new ItemStack(block)).contains("plankWood")) {
                    drops = new ItemStack(Items.field_151055_y, 3).func_77946_l();
                    RandomUtils.dropItemStackInWorld(world, x, y, z, drops);
                } else if (!RandomUtils.getItemStackName(new ItemStack(block)).isEmpty() && RandomUtils.getItemStackName(new ItemStack(block)).contains("logWood")) {
                    drops = RandomUtils.logToPlank.get(new MapKey(new ItemStack(block, 1, metadata))).func_77946_l();
                    drops.field_77994_a = 6;
                    RandomUtils.dropItemStackInWorld(world, x, y, z, drops);
                } else {
                    RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                }
                world.func_147468_f(x, y, z);
            }
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLivingBase;
                EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)player, (int)lpConsumption);
                if (this.getToolMode(stack) != 0 && world.field_73012_v.nextInt(20) == 0) {
                    SoulCorruptionHelper.incrementCorruption(world.func_72924_a(RandomUtils.getItemOwner(stack)));
                }
            }
        }
        return this.getToolMode(stack) <= 3;
    }

    public int getToolMode(ItemStack stack) {
        if (stack != null) {
            RandomUtils.checkAndSetCompound(stack);
            return stack.field_77990_d.func_74762_e("ToolMode");
        }
        return 0;
    }

    public void setToolMode(ItemStack stack, int mode) {
        RandomUtils.checkAndSetCompound(stack);
        stack.field_77990_d.func_74768_a("ToolMode", mode);
    }

    public void nextToolMode(ItemStack stack) {
        RandomUtils.checkAndSetCompound(stack);
        if (stack.field_77990_d.func_74762_e("ToolMode") + 1 <= 3) {
            this.setToolMode(stack, stack.field_77990_d.func_74762_e("ToolMode") + 1);
        } else {
            stack.field_77990_d.func_74768_a("ToolMode", 0);
            this.setToolMode(stack, 0);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        RandomUtils.checkAndSetCompound(stack);
        this.setToolMode(stack, 0);
        super.func_77622_d(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!GuiScreen.func_146272_n()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shift.info"));
        } else if (stack.func_77942_o()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode") + ": " + this.tooltipForMode(stack.field_77990_d.func_74762_e("ToolMode")));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.1"));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.2") + ": " + String.valueOf(this.minimumCorruption));
        }
    }

    public String tooltipForMode(int modeID) {
        String mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode.regular");
        if (modeID == 1) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.axe.mode.leaf.decay");
        } else if (modeID == 2) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.axe.mode.head.hunter");
        } else if (modeID == 3) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.axe.mode.refine");
        }
        return mode;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        EnergyItems.checkAndSetItemOwner((ItemStack)stack, (EntityPlayer)player);
        if (player.func_70093_af()) {
            this.nextToolMode(stack);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        RandomUtils.checkAndSetCompound(stack);
        stack.func_77964_b(0);
        super.func_77663_a(stack, world, entity, par4, par5);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)player, (int)100);
            if (this.getToolMode(stack) == 2 && player.field_70170_p.field_73012_v.nextInt(20) == 0) {
                SoulCorruptionHelper.incrementCorruption(((EntityPlayer)attacker).field_70170_p.func_72924_a(RandomUtils.getItemOwner(stack)));
            }
            return true;
        }
        return false;
    }

    public ItemStack getSkullDrop(EntityLivingBase entity) {
        if (entity instanceof EntitySkeleton) {
            int type = ((EntitySkeleton)entity).func_82202_m();
            if (type == 1) {
                return new ItemStack(Items.field_151144_bL, 1, 1);
            }
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entity instanceof EntityPlayer) {
            String name = entity.func_70005_c_();
            ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
            RandomUtils.checkAndSetCompound(skull);
            skull.field_77990_d.func_74778_a("SkullOwner", name);
            return skull;
        }
        if (entity instanceof EntityZombie) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (entity instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        return null;
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        int corruption;
        EntityPlayer player;
        if (event.source.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)event.source.func_76346_g()).func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemCorruptedAxe && (corruption = SoulCorruptionHelper.getCorruptionLevel(player)) != 0) {
            int chance = 100 * (this.minimumCorruption / corruption);
            if (chance < 1) {
                chance = 1;
            }
            if (player.field_70170_p.field_73012_v.nextInt(chance) == 0 && this.getSkullDrop(event.entityLiving) != null) {
                RandomUtils.dropItemStackInWorld(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, this.getSkullDrop(event.entityLiving).func_77946_l());
            }
        }
    }
}

