/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.api.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tombenpotter.sanguimancy.api.objects.ICustomNBTTag;
import tombenpotter.sanguimancy.api.objects.Timer;
import tombenpotter.sanguimancy.compat.lua.events.LuaEvent;
import tombenpotter.sanguimancy.compat.lua.methods.LuaMethod;
import tombenpotter.sanguimancy.util.enums.ModList;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers")})
public abstract class TileComputerBase
extends TileEntity
implements ManagedPeripheral,
Environment,
IPeripheral,
ICustomNBTTag {
    protected final String name;
    protected final Map<Integer, String> methodIDs = new LinkedHashMap<Integer, String>();
    protected final Map<String, LuaMethod> methodNames = new LinkedHashMap<String, LuaMethod>();
    protected final Map<Timer, LuaEvent> events = new LinkedHashMap<Timer, LuaEvent>();
    private final Object node = ModList.opencomputers.isLoaded() ? this.createNode() : null;
    private boolean initialize = true;
    private Set<Object> computers = new LinkedHashSet<Object>();
    private Set<Object> context = new LinkedHashSet<Object>();

    public TileComputerBase(String name) {
        this.name = name;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.serverUpdate();
        }
        if (this.initialize) {
            this.init();
        }
    }

    public void init() {
        if (ModList.opencomputers.isLoaded() && this.node instanceof Component && ((Component)this.node).network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        this.initialize = false;
    }

    public void serverUpdate() {
        for (Timer timer : this.events.keySet()) {
            if (!timer.update()) continue;
            this.events.get(timer).checkEvent(this);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (ModList.opencomputers.isLoaded() && this.node instanceof Component) {
            ((Component)this.node).load(compound);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (ModList.opencomputers.isLoaded() && this.node instanceof Component) {
            ((Component)this.node).save(compound);
        }
    }

    public String[] getMethods() {
        return this.methodNames.keySet().toArray(new String[this.methodNames.size()]);
    }

    public void addMethod(LuaMethod method) {
        if (ModList.computercraft.isLoaded() || ModList.opencomputers.isLoaded()) {
            int num = this.methodIDs.size();
            if (!this.methodNames.containsKey(method.getMethodName())) {
                this.methodIDs.put(num, method.getMethodName());
                this.methodNames.put(method.getMethodName(), method);
            }
        }
    }

    public void addEvent(LuaEvent event, int count) {
        if (ModList.computercraft.isLoaded() || ModList.opencomputers.isLoaded()) {
            this.events.put(new Timer(count), event);
        }
    }

    public String getType() {
        return this.name;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.getMethods();
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess iComputerAccess, ILuaContext iLuaContext, int i, Object[] objects) throws LuaException, InterruptedException {
        try {
            return this.methodIDs.containsKey(i) ? this.methodNames.get(this.methodIDs.get(i)).call(this, objects) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess iComputerAccess) {
        this.computers.add(iComputerAccess);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess iComputerAccess) {
        this.computers.remove(iComputerAccess);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral iPeripheral) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public Set<Object> getComputers() {
        return this.computers;
    }

    public String getComponentName() {
        return this.getType();
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return this.getMethods();
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] objs = new Object[args.count()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = args.checkAny(i);
        }
        return this.methodNames.containsKey(method) ? this.methodNames.get(method).call(this, objs) : null;
    }

    @Optional.Method(modid="OpenComputers")
    public final void onChunkUnload() {
        super.onChunkUnload();
        if (ModList.opencomputers.isLoaded() && this.node instanceof Component) {
            ((Component)this.node).remove();
        }
        this.onInvalidateOrUnload(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    @Optional.Method(modid="OpenComputers")
    public final void func_145843_s() {
        super.func_145843_s();
        if (this.node instanceof Component) {
            ((Component)this.node).remove();
        }
        this.onInvalidateOrUnload(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
    }

    @Optional.Method(modid="OpenComputers")
    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
    }

    @Optional.Method(modid="OpenComputers")
    private Node createNode() {
        return Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getType(), this.getOCNetworkVisibility()).create();
    }

    @Optional.Method(modid="OpenComputers")
    protected Visibility getOCNetworkVisibility() {
        return Visibility.Network;
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            this.context.add(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            this.context.remove(node.host());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    public Set<Object> getContext() {
        return this.context;
    }
}

