/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.api.soulCorruption;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruption;
import tombenpotter.sanguimancy.entity.EntityChickenMinion;
import tombenpotter.sanguimancy.registry.BlocksRegistry;
import tombenpotter.sanguimancy.registry.PotionsRegistry;
import tombenpotter.sanguimancy.util.ConfigHandler;

public class SoulCorruptionHelper {
    public static int getCorruptionLevel(EntityPlayer player) {
        return SoulCorruption.getSoulCorruption(player);
    }

    public static void setCorruptionLevel(EntityPlayer player, int level) {
        SoulCorruption.get(player).setSoulCorruption(level);
    }

    public static boolean isCorruptionEqual(EntityPlayer player, int level) {
        return SoulCorruptionHelper.getCorruptionLevel(player) == level;
    }

    public static boolean isCorruptionOver(EntityPlayer player, int level) {
        return SoulCorruptionHelper.getCorruptionLevel(player) >= level;
    }

    public static boolean isCorruptionLower(EntityPlayer player, int level) {
        return SoulCorruptionHelper.getCorruptionLevel(player) <= level;
    }

    public static void negateCorruption(EntityPlayer player) {
        SoulCorruptionHelper.setCorruptionLevel(player, 0);
    }

    public static void addCorruption(EntityPlayer player, int level) {
        SoulCorruptionHelper.setCorruptionLevel(player, SoulCorruptionHelper.getCorruptionLevel(player) + level);
    }

    public static void removeCorruption(EntityPlayer player, int level) {
        SoulCorruptionHelper.setCorruptionLevel(player, SoulCorruptionHelper.getCorruptionLevel(player) - level);
    }

    public static void incrementCorruption(EntityPlayer player) {
        SoulCorruptionHelper.addCorruption(player, 1);
    }

    public static void decrementCorruption(EntityPlayer player) {
        SoulCorruptionHelper.removeCorruption(player, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getClientPlayerCorruption() {
        return Sanguimancy.proxy.getClientPlayer().getEntityData().func_74762_e("Sanguimancy:SC");
    }

    public static void spawnChickenFollower(EntityPlayer player) {
        if (player.field_70170_p.field_73012_v.nextInt(10000) == 0) {
            EntityChickenMinion minion = new EntityChickenMinion(player.field_70170_p);
            minion.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            String owner = player.func_110124_au().toString();
            minion.func_152115_b(owner);
            minion.func_70903_f(true);
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72838_d((Entity)minion);
            }
            if (!player.field_70170_p.field_72995_K && ConfigHandler.serverMessagesWhenCorruptionEffect) {
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.chicken.minion"), player.getDisplayName())));
            }
            if (!player.field_70170_p.field_72995_K && ConfigHandler.playerMessageWhenCorruptionEffect) {
                player.func_146105_b((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.chicken.minion"), player.getDisplayName())));
            }
        }
    }

    public static void randomTeleport(EntityPlayer player) {
        if (player.field_70170_p.field_73012_v.nextInt(5000) == 0) {
            player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v));
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 20, 0));
            }
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 20, 0));
            }
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 20, 0));
            }
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 20, 0));
            }
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 0));
            }
            if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 20, 0));
            }
            int i = (int)(player.field_70165_t + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
            int j = (int)(player.field_70163_u + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
            int k = (int)(player.field_70161_v + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
            if (j <= 5) {
                j += 10;
            }
            player.func_70634_a((double)i, (double)j, (double)k);
            SoulCorruptionHelper.decrementCorruption(player);
            if (!player.field_70170_p.field_72995_K && ConfigHandler.serverMessagesWhenCorruptionEffect) {
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.random.teleport"), player.getDisplayName())));
            }
            if (!player.field_70170_p.field_72995_K && ConfigHandler.playerMessageWhenCorruptionEffect) {
                player.func_146105_b((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.random.teleport"), player.getDisplayName())));
            }
        }
    }

    public static void killGrass(EntityPlayer player) {
        int z;
        int y;
        int x;
        if (player.field_70170_p.field_73012_v.nextInt(10) == 0 && player.field_70170_p.func_147439_a(x = (int)player.field_70165_t, y = (int)player.field_70163_u - 1, z = (int)player.field_70161_v) == Blocks.field_150349_c) {
            player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public static void hurtAndHealAnimals(EntityPlayer player) {
        if (player.field_70170_p.field_73012_v.nextInt(10) == 0) {
            int range = 4;
            int rangeY = 4;
            List entities = player.field_70170_p.func_72872_a(EntityAnimal.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)range), (double)(player.field_70163_u - (double)rangeY), (double)(player.field_70161_v - (double)range), (double)(player.field_70165_t + (double)range), (double)(player.field_70163_u + (double)rangeY), (double)(player.field_70161_v + (double)range)));
            for (EntityAnimal animal : entities) {
                if (animal.getClass() == EntityChickenMinion.class) continue;
                animal.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                animal.func_70691_i(1.0f);
            }
        }
    }

    public static void addWither(EntityLivingBase livingBase) {
        livingBase.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100));
    }

    public static void spawnIllusion(EntityPlayer player) {
        int i = (int)(player.field_70165_t + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
        int j = (int)(player.field_70163_u + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
        int k = (int)(player.field_70161_v + (double)player.field_70170_p.field_73012_v.nextInt(16) - (double)player.field_70170_p.field_73012_v.nextInt(16));
        if (j <= 0) {
            j += 5;
        }
        if (player.field_70170_p.field_73012_v.nextInt(500) == 0 && player.field_70170_p.func_147437_c(i, j, k)) {
            player.field_70170_p.func_147465_d(i, j, k, BlocksRegistry.illusion, player.field_70170_p.field_73012_v.nextInt(16), 3);
        }
    }

    public static void loseHeart(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && player.field_70170_p.field_73012_v.nextInt(750) == 0) {
            int level = player.field_70170_p.field_73012_v.nextInt(5);
            player.func_70690_d(new PotionEffect(PotionsRegistry.potionRemoveHeart.field_76415_H, 1200, level, false));
            if (!player.field_70170_p.field_72995_K && ConfigHandler.serverMessagesWhenCorruptionEffect) {
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.loose.heart"), player.getDisplayName())));
            }
            if (!player.field_70170_p.field_72995_K && ConfigHandler.playerMessageWhenCorruptionEffect) {
                player.func_146105_b((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"chat.Sanguimancy.loose.heart"), player.getDisplayName())));
            }
        }
    }
}

