/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;

@ContentInit
public class ItemVoidTear
extends ItemToggleable {
    public ItemVoidTear() {
        super("void_tear");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(null, stack, list);
        ItemStack contents = this.getContainedItem(stack);
        if (this.isEnabled(stack)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.YELLOW + contents.func_82833_r())), (ItemStack)stack, (List)list);
            list.add(LanguageHelper.getLocalization((String)"tooltip.absorb_tear"));
        }
        LanguageHelper.formatTooltip((String)"tooltip.tear_quantity", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)contents.func_82833_r(), (Object)"amount", (Object)Integer.toString(contents.field_77994_a)), (ItemStack)stack, (List)list);
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                return super.func_77659_a(ist, world, player);
            }
            if (this.attemptToEmptyIntoInventory(ist, player, (IInventory)player.field_71071_by, player.field_71071_by.field_70462_a.length)) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                NBTHelper.resetTag((ItemStack)ist);
                return new ItemStack(Reliquary.CONTENT.getItem("void_tear_empty"), 1, 0);
            }
        }
        ist.func_77964_b(ist.func_77960_j() == 0 ? 1 : 0);
        return ist;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean f) {
        if (!world.field_72995_K) {
            if (!this.isEnabled(stack) || !(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack contents = this.getContainedItem(stack);
            if (contents.field_77994_a < Reliquary.CONFIG.getInt("void_tear", "item_limit") && InventoryHelper.consumeItem((Object)contents, (EntityPlayer)player, (int)contents.func_77976_d()) && !player.field_71075_bZ.field_75098_d) {
                this.onAbsorb(stack, player);
            }
            this.attemptToReplenishSingleStack(player, stack);
        }
    }

    public void attemptToReplenishSingleStack(EntityPlayer player, ItemStack ist) {
        int preferredSlot = -1;
        int stackCount = 0;
        InventoryPlayer inventory = player.field_71071_by;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stackFound = inventory.func_70301_a(slot);
            if (stackFound == null || !stackFound.func_77969_a(this.getContainedItem(ist))) continue;
            if (preferredSlot == -1) {
                preferredSlot = slot;
            }
            ++stackCount;
        }
        if (stackCount == 1 && preferredSlot != -1) {
            ItemStack stackToIncrease = player.field_71071_by.func_70301_a(preferredSlot);
            if (stackToIncrease == null) {
                return;
            }
            while (stackToIncrease.field_77994_a < stackToIncrease.func_77976_d() && this.getContainedItem((ItemStack)ist).field_77994_a > 1) {
                ++stackToIncrease.field_77994_a;
                NBTHelper.setInteger((String)"itemQuantity", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"itemQuantity", (ItemStack)ist) - 1));
            }
        }
    }

    public boolean onItemUseFirst(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_147438_o(x, y, z);
            if (this.isEnabled(ist)) {
                this.drainInventory(ist, player, inventory);
            } else if (this.attemptToEmptyIntoInventory(ist, player, inventory, 0)) {
                NBTHelper.resetTag((ItemStack)ist);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Reliquary.CONTENT.getItem("void_tear_empty"), 1, 0));
            }
            return true;
        }
        return false;
    }

    protected void onAbsorb(ItemStack ist, EntityPlayer player) {
        NBTHelper.setInteger((String)"itemQuantity", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"itemQuantity", (ItemStack)ist) + 1));
    }

    public ItemStack getContainedItem(ItemStack ist) {
        if (NBTHelper.getString((String)"itemID", (ItemStack)ist).equals("")) {
            return null;
        }
        return new ItemStack((Item)Item.field_150901_e.func_82594_a(NBTHelper.getString((String)"itemID", (ItemStack)ist)), NBTHelper.getInteger((String)"itemQuantity", (ItemStack)ist), NBTHelper.getShort((String)"itemMeta", (ItemStack)ist));
    }

    protected boolean attemptToEmptyIntoInventory(ItemStack ist, EntityPlayer player, IInventory inventory, int limit) {
        int quantity;
        ItemStack contents = this.getContainedItem(ist);
        contents.field_77994_a = 1;
        int minQuantity = quantity - contents.func_77976_d();
        for (quantity = NBTHelper.getInteger((String)"itemQuantity", (ItemStack)ist); quantity > Math.max(0, minQuantity) && this.tryToAddToInventory(contents, inventory, limit); --quantity) {
        }
        if (quantity == 0) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        NBTHelper.setInteger((String)"itemQuantity", (ItemStack)ist, (int)quantity);
        return false;
    }

    protected void drainInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        int quantity;
        ItemStack contents = this.getContainedItem(ist);
        int limit = 0;
        boolean foundItem = false;
        for (quantity = NBTHelper.getInteger((String)"itemQuantity", (ItemStack)ist); quantity < Reliquary.CONFIG.getInt("void_tear", "item_limit") && this.tryToRemoveFromInventory(contents, inventory, limit); ++quantity) {
            if (foundItem) continue;
            foundItem = true;
        }
        if (foundItem) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        }
        NBTHelper.setInteger((String)"itemQuantity", (ItemStack)ist, (int)quantity);
    }

    public boolean tryToAddToInventory(ItemStack contents, IInventory inventory, int limit) {
        int slot;
        for (slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            if (inventory.func_70301_a(slot) == null || !inventory.func_70301_a(slot).func_77969_a(contents) || inventory.func_70301_a((int)slot).field_77994_a == inventory.func_70301_a(slot).func_77976_d()) continue;
            inventory.func_70299_a(slot, new ItemStack(contents.func_77973_b(), inventory.func_70301_a((int)slot).field_77994_a + 1, contents.func_77960_j()));
            return true;
        }
        for (slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            if (inventory.func_70301_a(slot) != null) continue;
            inventory.func_70299_a(slot, new ItemStack(contents.func_77973_b(), contents.field_77994_a, contents.func_77960_j()));
            return true;
        }
        return false;
    }

    public boolean tryToRemoveFromInventory(ItemStack contents, IInventory inventory, int limit) {
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            if (inventory.func_70301_a(slot) == null || !inventory.func_70301_a(slot).func_77969_a(contents)) continue;
            inventory.func_70298_a(slot, 1);
            return true;
        }
        return false;
    }
}

