/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;

@ContentInit
public class ItemRendingGale
extends ItemToggleable {
    public ItemRendingGale() {
        super("rending_gale");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger((String)"feathers", (ItemStack)ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.WHITE + Items.field_151008_G.func_77653_i(new ItemStack(Items.field_151008_G)))), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    private static int getChargeLimit() {
        return Reliquary.CONFIG.getInt("rending_gale", "charge_limit");
    }

    public static int getChargeCost() {
        return Reliquary.CONFIG.getInt("rending_gale", "cast_charge_cost");
    }

    private static int getFeathersWorth() {
        return Reliquary.CONFIG.getInt("rending_gale", "charge_feather_worth");
    }

    private static int getBoltChargeCost() {
        return Reliquary.CONFIG.getInt("rending_gale", "bolt_charge_cost");
    }

    private static int getBoltTargetRange() {
        return Reliquary.CONFIG.getInt("rending_gale", "block_target_range");
    }

    private static int getRadialPushRadius() {
        return Reliquary.CONFIG.getInt("rending_gale", "push_pull_radius");
    }

    private static boolean canPushProjectiles() {
        return Reliquary.CONFIG.getBool("rending_gale", "can_push_projectiles");
    }

    public boolean func_77662_d() {
        return true;
    }

    public void attemptFlight(EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        Vec3 lookVec = player.func_70676_i(0.66f);
        double x = lookVec.field_72450_a;
        double y = lookVec.field_72448_b;
        double z = lookVec.field_72449_c;
        if (this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, y, z))) {
            if (Math.abs(x) > Math.abs(y) && Math.abs(x) > Math.abs(z)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                    if (Math.abs(z) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                            z = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                        y = 0.0;
                    }
                } else {
                    x = 0.0;
                    if (Math.abs(z) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                            z = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                        y = 0.0;
                    }
                }
            } else if (Math.abs(z) > Math.abs(x) && Math.abs(z) > Math.abs(y)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                    if (Math.abs(x) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                        y = 0.0;
                    }
                } else {
                    z = 0.0;
                    if (Math.abs(x) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                        y = 0.0;
                    }
                }
            } else if (Math.abs(y) > Math.abs(x) && Math.abs(y) > Math.abs(z)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, y, 0.0))) {
                    if (Math.abs(x) > Math.abs(z)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                            z = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                        x = 0.0;
                    }
                } else {
                    y = 0.0;
                    if (Math.abs(x) > Math.abs(z)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                            z = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(0.0, 0.0, z))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, 0.0, 0.0))) {
                        z = 0.0;
                    }
                }
            }
            if (this.isAABBInAnythingButAir(player.field_70170_p, player.field_70121_D.func_72325_c(x, y, z))) {
                return;
            }
        }
        player.field_70159_w = x;
        player.field_70181_x = y;
        player.field_70179_y = z;
        player.func_70107_b(player.field_70165_t + x, player.field_70163_u + y, player.field_70161_v + z);
        player.field_70143_R = 0.0f;
    }

    public boolean isAABBInAnythingButAir(World worldObj, AxisAlignedBB aabb) {
        int minX = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int xOff = minX; xOff < maxX; ++xOff) {
            for (int yOff = minY; yOff < maxY; ++yOff) {
                for (int zOff = minZ; zOff < maxZ; ++zOff) {
                    Block block = worldObj.func_147439_a(xOff, yOff, zOff);
                    if (block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151586_h || block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151581_o || block.func_149688_o() == Material.field_151582_l || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151594_q) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (this.isEnabled(ist) && NBTHelper.getInteger((String)"feathers", (ItemStack)ist) + ItemRendingGale.getFeathersWorth() <= ItemRendingGale.getChargeLimit() && InventoryHelper.consumeItem((Object)new ItemStack(Items.field_151008_G), (EntityPlayer)player)) {
            NBTHelper.setInteger((String)"feathers", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"feathers", (ItemStack)ist) + ItemRendingGale.getFeathersWorth()));
        }
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString((String)"mode", (ItemStack)ist).equals("")) {
            this.setMode(ist, "flight");
        }
        return NBTHelper.getString((String)"mode", (ItemStack)ist);
    }

    public void setMode(ItemStack ist, String s) {
        NBTHelper.setString((String)"mode", (ItemStack)ist, (String)s);
    }

    public void cycleMode(ItemStack ist, boolean isRaining) {
        if (this.getMode(ist).equals("flight")) {
            this.setMode(ist, "push");
        } else if (this.getMode(ist).equals("push")) {
            this.setMode(ist, "pull");
        } else if (this.getMode(ist).equals("pull") && isRaining) {
            this.setMode(ist, "bolt");
        } else {
            this.setMode(ist, "flight");
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist, player.field_70170_p.func_72896_J());
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 64;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            super.func_77659_a(ist, world, player);
        } else {
            player.func_71008_a(ist, this.func_77626_a(ist));
        }
        return ist;
    }

    public MovingObjectPosition getCycloneBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = ItemRendingGale.getBoltTargetRange();
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int count) {
        MovingObjectPosition mop;
        if (NBTHelper.getInteger((String)"feathers", (ItemStack)ist) < ItemRendingGale.getChargeCost()) {
            return;
        }
        --count;
        count = this.func_77626_a(ist) - count;
        if (count == this.func_77626_a(ist) || (this.func_77626_a(ist) - count) * ItemRendingGale.getChargeCost() >= NBTHelper.getInteger((String)"feathers", (ItemStack)ist)) {
            int chargeUsed = count * ItemRendingGale.getChargeCost();
            NBTHelper.setInteger((String)"feathers", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"feathers", (ItemStack)ist) - chargeUsed));
            player.func_71034_by();
        }
        if (this.getMode(ist).equals("flight")) {
            this.attemptFlight((EntityLivingBase)player);
            this.spawnFlightParticles(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.func_70040_Z());
        } else if (this.getMode(ist).equals("push")) {
            this.doRadialPush(player, false);
        } else if (this.getMode(ist).equals("pull")) {
            this.doRadialPush(player, true);
        } else if (this.getMode(ist).equals("bolt") && (mop = this.getCycloneBlockTarget(player.field_70170_p, player)) != null && count % 8 == 0) {
            int attemptedY = mop.field_72312_c;
            if (!player.field_70170_p.func_72951_B(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                ++attemptedY;
            }
            if (player.field_70170_p.func_72951_B(mop.field_72311_b, attemptedY, mop.field_72309_d) && NBTHelper.getInteger((String)"feathers", (ItemStack)ist) >= ItemRendingGale.getBoltChargeCost()) {
                NBTHelper.setInteger((String)"feathers", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"feathers", (ItemStack)ist) - ItemRendingGale.getBoltChargeCost()));
                player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d));
            }
        }
    }

    public void func_77615_a(ItemStack ist, World world, EntityPlayer player, int count) {
        if (world.field_72995_K) {
            return;
        }
        int chargeUsed = (this.func_77626_a(ist) - --count) * ItemRendingGale.getChargeCost();
        NBTHelper.setInteger((String)"feathers", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"feathers", (ItemStack)ist) - Math.min(chargeUsed, NBTHelper.getInteger((String)"feathers", (ItemStack)ist))));
    }

    public void doRadialPush(EntityPlayer player, boolean pull) {
        this.spawnRadialHurricaneParticles(player, pull);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double lowerX = player.field_70165_t - (double)ItemRendingGale.getRadialPushRadius();
        double lowerY = player.field_70163_u - (double)ItemRendingGale.getRadialPushRadius() / 5.0;
        double lowerZ = player.field_70161_v - (double)ItemRendingGale.getRadialPushRadius();
        double upperX = player.field_70165_t + (double)ItemRendingGale.getRadialPushRadius();
        double upperY = player.field_70163_u + (double)ItemRendingGale.getRadialPushRadius() / 2.0;
        double upperZ = player.field_70161_v + (double)ItemRendingGale.getRadialPushRadius();
        List entitiesThatCanBePushed = (List)Reliquary.CONFIG.get("rending_gale", "entities_that_can_be_pushed");
        List projectilesThatCanBePushed = (List)Reliquary.CONFIG.get("rending_gale", "projectiles_that_can_be_pushed");
        List eList = player.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)lowerX, (double)lowerY, (double)lowerZ, (double)upperX, (double)upperY, (double)upperZ));
        for (Entity e : eList) {
            double distance;
            Class<?> entityClass = e.getClass();
            String entityName = (String)EntityList.field_75626_c.get(entityClass);
            if (!entitiesThatCanBePushed.contains(entityName) && (pull || !ItemRendingGale.canPushProjectiles() || !projectilesThatCanBePushed.contains(entityName)) || (distance = (double)player.func_70032_d(e)) >= (double)ItemRendingGale.getRadialPushRadius() || e.equals((Object)player)) continue;
            Vec3 pushVector = pull ? Vec3.func_72443_a((double)(player.field_70165_t - e.field_70165_t), (double)(player.field_70163_u - e.field_70163_u), (double)(player.field_70161_v - e.field_70161_v)) : Vec3.func_72443_a((double)(e.field_70165_t - player.field_70165_t), (double)(e.field_70163_u - player.field_70163_u), (double)(e.field_70161_v - player.field_70161_v));
            pushVector = pushVector.func_72432_b();
            e.func_70091_d(0.0, 0.2, 0.0);
            e.func_70091_d(pushVector.field_72450_a, Math.min(pushVector.field_72448_b, 0.1) * 1.5, pushVector.field_72449_c);
        }
    }

    public void spawnFlightParticles(World world, double x, double y, double z, Vec3 lookVector) {
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randY = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randZ = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            world.func_72869_a("blockdust_" + Block.func_149682_b((Block)Blocks.field_150431_aC) + "_" + 0, x + (double)randX, y + (double)randY, z + (double)randZ, lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0);
        }
    }

    public void spawnRadialHurricaneParticles(EntityPlayer player, boolean pull) {
        for (int i = 0; i < 3; ++i) {
            float randX = player.field_70170_p.field_73012_v.nextFloat() - 0.5f;
            float randZ = player.field_70170_p.field_73012_v.nextFloat() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            player.field_70170_p.func_72869_a("blockdust_" + Block.func_149682_b((Block)Blocks.field_150431_aC) + "_" + 0, player.field_70165_t + (double)randX, player.field_70163_u + (double)player.func_70047_e() - (double)(player.field_70131_O / 2.0f), player.field_70161_v + (double)randZ, (double)motX, 0.0, (double)motZ);
        }
    }
}

