/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;

@ContentInit
public class ItemHeroMedallion
extends ItemToggleable {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconOverlay;

    public ItemHeroMedallion() {
        super("hero_medallion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.func_77960_j() == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "hero_medallion_overlay");
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        if (itemStack.func_77960_j() == 0 || renderPass != 1) {
            return this.field_77791_bV;
        }
        return this.iconOverlay;
    }

    public void func_77624_a(ItemStack ist, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(ImmutableMap.of((Object)"experience", (Object)String.valueOf(NBTHelper.getInteger((String)"experience", (ItemStack)ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.GREEN + "XP")), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    private int getExperienceMinimum() {
        return Reliquary.CONFIG.getInt("hero_medallion", "experience_level_minimum");
    }

    private int getExperienceMaximum() {
        return Reliquary.CONFIG.getInt("hero_medallion", "experience_level_maximum");
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(ist)) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            int levelLoop = 0;
            while ((double)levelLoop <= Math.sqrt(player.field_71068_ca)) {
                if ((player.field_71068_ca > this.getExperienceMinimum() || player.field_71106_cc > 0.0f) && this.getExperience(ist) < Integer.MAX_VALUE) {
                    this.decreasePlayerExperience(player);
                    this.increaseMedallionExperience(ist);
                }
                ++levelLoop;
            }
        }
    }

    public void decreasePlayerExperience(EntityPlayer player) {
        if (player.field_71106_cc - 1.0f / (float)player.func_71050_bK() <= 0.0f && player.field_71068_ca > this.getExperienceMinimum()) {
            this.decreasePlayerLevel(player);
            return;
        }
        player.field_71106_cc -= Math.min(1.0f / (float)player.func_71050_bK(), player.field_71106_cc);
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
    }

    public void decreaseMedallionExperience(ItemStack ist) {
        this.setExperience(ist, this.getExperience(ist) - 1);
    }

    public void decreasePlayerLevel(EntityPlayer player) {
        player.field_71106_cc = 1.0f - 1.0f / (float)player.func_71050_bK();
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
        --player.field_71068_ca;
    }

    public void increasePlayerExperience(EntityPlayer player) {
        player.func_71023_q(1);
    }

    public void increaseMedallionExperience(ItemStack ist) {
        this.setExperience(ist, this.getExperience(ist) + 1);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInteger((String)"experience", (ItemStack)stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.setInteger((String)"experience", (ItemStack)stack, (int)i);
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return ist;
        }
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player);
        }
        int playerLevel = player.field_71068_ca;
        while (player.field_71068_ca < this.getExperienceMaximum() && playerLevel == player.field_71068_ca && this.getExperience(ist) > 0) {
            this.increasePlayerExperience(player);
            this.decreaseMedallionExperience(ist);
        }
        return ist;
    }
}

