/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import baubles.api.BaubleType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.items.ItemBauble;

@ContentInit
public class ItemFortuneCoin
extends ItemBauble {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconOverlay;

    public ItemFortuneCoin() {
        super("fortune_coin");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack ist, int pass) {
        return NBTHelper.getBoolean((String)"enabled", (ItemStack)ist);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "fortune_coin_overlay");
    }

    public IIcon getIcon(ItemStack ist, int renderPass) {
        if (!NBTHelper.getBoolean((String)"enabled", (ItemStack)ist) || renderPass != 1) {
            return this.field_77791_bV;
        }
        return this.iconOverlay;
    }

    public void func_77663_a(ItemStack ist, World world, Entity entity, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.disabledAudio() && NBTHelper.getShort((String)"soundTimer", (ItemStack)ist) > 0) {
            if (NBTHelper.getShort((String)"soundTimer", (ItemStack)ist) % 2 == 0) {
                world.func_72956_a(entity, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            }
            NBTHelper.setShort((String)"soundTimer", (ItemStack)ist, (int)(NBTHelper.getShort((String)"soundTimer", (ItemStack)ist) - 1));
        }
        if (!NBTHelper.getBoolean((String)"enabled", (ItemStack)ist)) {
            return;
        }
        EntityPlayer player = null;
        if (entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
        }
        if (player == null) {
            return;
        }
        this.scanForEntitiesInRange(world, player, this.getStandardPullDistance());
    }

    private void scanForEntitiesInRange(World world, EntityPlayer player, double d) {
        List iList = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - d), (double)(player.field_70163_u - d), (double)(player.field_70161_v - d), (double)(player.field_70165_t + d), (double)(player.field_70163_u + d), (double)(player.field_70161_v + d)));
        for (EntityItem item : iList) {
            if (!this.checkForRoom(item.func_92059_d(), player)) continue;
            if (item.field_145804_b > 0) {
                item.field_145804_b = 0;
            }
            if ((double)player.func_70032_d((Entity)item) < 1.5) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
        List iList2 = world.func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - d), (double)(player.field_70163_u - d), (double)(player.field_70161_v - d), (double)(player.field_70165_t + d), (double)(player.field_70163_u + d), (double)(player.field_70161_v + d)));
        for (EntityXPOrb item : iList2) {
            if (player.field_71090_bL > 0) {
                player.field_71090_bL = 0;
            }
            if ((double)player.func_70032_d((Entity)item) < 1.5) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
    }

    private void teleportEntityToPlayer(Entity item, EntityPlayer player) {
        player.field_70170_p.func_72869_a("mobSpell", item.field_70165_t + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, item.field_70163_u + 0.2, item.field_70161_v + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, 0.9, 0.9, 0.0);
        player.func_70040_Z();
        double x = player.field_70165_t + player.func_70040_Z().field_72450_a * 0.2;
        double y = player.field_70163_u - (double)(player.field_70131_O / 2.0f);
        double z = player.field_70161_v + player.func_70040_Z().field_72449_c * 0.2;
        item.func_70107_b(x, y, z);
        if (!this.disabledAudio()) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
        }
    }

    private boolean checkForRoom(ItemStack item, EntityPlayer player) {
        int remaining = item.field_77994_a;
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != item.func_77973_b() || ist.func_77960_j() != item.func_77960_j()) continue;
            if (ist.field_77994_a + remaining <= ist.func_77976_d()) {
                return true;
            }
            for (int count = ist.field_77994_a; count < ist.func_77976_d(); ++count) {
                if (--remaining != 0) continue;
                return true;
            }
        }
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] != null) continue;
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int count) {
        this.scanForEntitiesInRange(player.field_70170_p, player, this.getLongRangePullDistance());
    }

    public double getLongRangePullDistance() {
        return Reliquary.CONFIG.getInt("fortune_coin", "long_range_pull_distance").intValue();
    }

    public double getStandardPullDistance() {
        return Reliquary.CONFIG.getInt("fortune_coin", "standard_pull_distance").intValue();
    }

    public int func_77626_a(ItemStack stack) {
        return 64;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!this.disabledAudio()) {
                NBTHelper.setShort((String)"soundTimer", (ItemStack)ist, (int)6);
            }
            NBTHelper.setBoolean((String)"enabled", (ItemStack)ist, (!NBTHelper.getBoolean((String)"enabled", (ItemStack)ist) ? 1 : 0) != 0);
        } else {
            player.func_71008_a(ist, this.func_77626_a(ist));
        }
        return ist;
    }

    @Override
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.AMULET;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    private boolean disabledAudio() {
        return Reliquary.CONFIG.getBool("fortune_coin", "disable_audio");
    }
}

