/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.entities.EntitySpellEffect;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class FireRain
implements ISpellComponent {
    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 3);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 2);
        objectArray[2] = Blocks.field_150424_aL;
        objectArray[3] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 3);
        objectArray[4] = Items.field_151129_at;
        return objectArray;
    }

    @Override
    public int getID() {
        return 66;
    }

    private boolean spawnFireRain(ItemStack stack, World world, EntityLivingBase caster, Entity target, double x, double y, double z) {
        List zones = world.func_72872_a(EntitySpellEffect.class, AxisAlignedBB.func_72330_a((double)(x - 10.0), (double)(y - 10.0), (double)(z - 10.0), (double)(x + 10.0), (double)(y + 10.0), (double)(z + 10.0)));
        for (EntitySpellEffect zone : zones) {
            if (!zone.isRainOfFire()) continue;
            return false;
        }
        if (!world.field_72995_K) {
            int radius = SpellUtils.instance.getModifiedInt_Add(2, stack, caster, target, world, 0, SpellModifiers.RADIUS) / 2 + 1;
            double damage = SpellUtils.instance.getModifiedDouble_Mul(1.0, stack, caster, target, world, 0, SpellModifiers.DAMAGE);
            int duration = SpellUtils.instance.getModifiedInt_Mul(100, stack, caster, target, world, 0, SpellModifiers.DURATION);
            EntitySpellEffect fire = new EntitySpellEffect(world);
            fire.func_70107_b(x, y, z);
            fire.setRainOfFire(false);
            fire.setRadius(radius);
            fire.setDamageBonus((float)damage);
            fire.setTicksToExist(duration);
            fire.SetCasterAndStack(caster, stack);
            world.func_72838_d((Entity)fire);
        }
        return true;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return this.spawnFireRain(stack, world, caster, (Entity)caster, impactX, impactY, impactZ);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return this.spawnFireRain(stack, world, caster, target, target.field_70165_t, target.field_70163_u, target.field_70161_v);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 3000.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 200.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.1f;
    }
}

