/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Accelerate
implements ISpellComponent {
    private final Random rand = new Random();

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block block;
        if (this.rand.nextDouble() < 0.5 && (block = world.func_147439_a(blockx, blocky, blockz)) != Blocks.field_150350_a) {
            block.func_149674_a(world, blocky, blocky, blockz, this.rand);
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        caster.func_70659_e(caster.func_70689_ay() * 1.6f);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 6.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 2.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y, z));
        if (particle != null) {
            particle.AddParticleController(new ParticleOrbitEntity(particle, (Entity)caster, 0.1f, 1, false).SetTargetDistance(rand.nextDouble() + 0.5));
            particle.setMaxAge(25 + rand.nextInt(10));
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 0;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 16);
        objectArray[1] = Items.field_151021_T;
        objectArray[2] = Items.field_151137_ax;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

