/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.api.spell.ISpellPartManager;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.skills.AffinityGainsBoost;
import am2.skills.AugmentedCasting;
import am2.skills.ExtraSummon;
import am2.skills.MagePosseI;
import am2.skills.MagePosseII;
import am2.skills.ManaRegenBoostI;
import am2.skills.ManaRegenBoostII;
import am2.skills.ManaRegenBoostIII;
import am2.skills.SpellMovement;
import am2.spell.SpellRecipeManager;
import am2.spell.components.Accelerate;
import am2.spell.components.Appropriation;
import am2.spell.components.AstralDistortion;
import am2.spell.components.Attract;
import am2.spell.components.BanishRain;
import am2.spell.components.Blind;
import am2.spell.components.Blink;
import am2.spell.components.Blizzard;
import am2.spell.components.Charm;
import am2.spell.components.ChronoAnchor;
import am2.spell.components.CreateWater;
import am2.spell.components.Daylight;
import am2.spell.components.Dig;
import am2.spell.components.Disarm;
import am2.spell.components.Dispel;
import am2.spell.components.DivineIntervention;
import am2.spell.components.Drought;
import am2.spell.components.Drown;
import am2.spell.components.EnderIntervention;
import am2.spell.components.Entangle;
import am2.spell.components.FallingStar;
import am2.spell.components.FireDamage;
import am2.spell.components.FireRain;
import am2.spell.components.Flight;
import am2.spell.components.Fling;
import am2.spell.components.Forge;
import am2.spell.components.Freeze;
import am2.spell.components.FrostDamage;
import am2.spell.components.Fury;
import am2.spell.components.GravityWell;
import am2.spell.components.Grow;
import am2.spell.components.HarvestPlants;
import am2.spell.components.Haste;
import am2.spell.components.Heal;
import am2.spell.components.Ignition;
import am2.spell.components.Invisiblity;
import am2.spell.components.Knockback;
import am2.spell.components.Leap;
import am2.spell.components.Levitation;
import am2.spell.components.LifeDrain;
import am2.spell.components.LifeTap;
import am2.spell.components.Light;
import am2.spell.components.LightningDamage;
import am2.spell.components.MagicDamage;
import am2.spell.components.ManaDrain;
import am2.spell.components.ManaLink;
import am2.spell.components.ManaShield;
import am2.spell.components.Mark;
import am2.spell.components.MeltArmor;
import am2.spell.components.MissingComponent;
import am2.spell.components.Moonrise;
import am2.spell.components.Nauseate;
import am2.spell.components.NightVision;
import am2.spell.components.PhysicalDamage;
import am2.spell.components.PlaceBlock;
import am2.spell.components.Plant;
import am2.spell.components.Plow;
import am2.spell.components.RandomTeleport;
import am2.spell.components.Recall;
import am2.spell.components.Reflect;
import am2.spell.components.Regeneration;
import am2.spell.components.Repel;
import am2.spell.components.Rift;
import am2.spell.components.ScrambleSynapses;
import am2.spell.components.Shield;
import am2.spell.components.Shrink;
import am2.spell.components.Silence;
import am2.spell.components.Slow;
import am2.spell.components.Slowfall;
import am2.spell.components.Storm;
import am2.spell.components.Summon;
import am2.spell.components.SwiftSwim;
import am2.spell.components.Telekinesis;
import am2.spell.components.Transplace;
import am2.spell.components.TrueSight;
import am2.spell.components.WaterBreathing;
import am2.spell.components.WateryGrave;
import am2.spell.components.WizardsAutumn;
import am2.spell.modifiers.Bounce;
import am2.spell.modifiers.BuffPower;
import am2.spell.modifiers.Colour;
import am2.spell.modifiers.Damage;
import am2.spell.modifiers.Dismembering;
import am2.spell.modifiers.Duration;
import am2.spell.modifiers.FeatherTouch;
import am2.spell.modifiers.Gravity;
import am2.spell.modifiers.Healing;
import am2.spell.modifiers.Lunar;
import am2.spell.modifiers.MiningPower;
import am2.spell.modifiers.MissingModifier;
import am2.spell.modifiers.Piercing;
import am2.spell.modifiers.Prosperity;
import am2.spell.modifiers.Radius;
import am2.spell.modifiers.Range;
import am2.spell.modifiers.RuneProcs;
import am2.spell.modifiers.Solar;
import am2.spell.modifiers.Speed;
import am2.spell.modifiers.TargetNonSolidBlocks;
import am2.spell.modifiers.VelocityAdded;
import am2.spell.shapes.AoE;
import am2.spell.shapes.Beam;
import am2.spell.shapes.Binding;
import am2.spell.shapes.Chain;
import am2.spell.shapes.Channel;
import am2.spell.shapes.Contingency_Death;
import am2.spell.shapes.Contingency_Fall;
import am2.spell.shapes.Contingency_Fire;
import am2.spell.shapes.Contingency_Health;
import am2.spell.shapes.Contingency_Hit;
import am2.spell.shapes.MissingShape;
import am2.spell.shapes.Projectile;
import am2.spell.shapes.Rune;
import am2.spell.shapes.Self;
import am2.spell.shapes.Touch;
import am2.spell.shapes.Wall;
import am2.spell.shapes.Wave;
import am2.spell.shapes.Zone;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.util.StatCollector;

public class SkillManager
implements ISpellPartManager {
    public static final int COMPONENT_OFFSET = 1000;
    public static final int MODIFIER_OFFSET = 5000;
    public static final int TALENT_OFFSET = 6000;
    private final HashMap<Integer, ISkillTreeEntry> registeredParts = new HashMap();
    private final CaseInsensitiveMap<String, Integer> registeredPartNames = new CaseInsensitiveMap();
    private final HashMap<Integer, String> reversedPartNames = new HashMap();
    public static SkillManager instance = new SkillManager();
    public ISpellShape missingShape;
    public ISpellComponent missingComponent = new MissingComponent();
    public ISpellModifier missingModifier = new MissingModifier();

    private SkillManager() {
        this.missingShape = new MissingShape();
    }

    public ArrayList<Integer> getAllShapes() {
        ArrayList<Integer> shapes = new ArrayList<Integer>();
        for (Integer i : this.registeredParts.keySet()) {
            if (!(this.registeredParts.get(i) instanceof ISpellShape)) continue;
            shapes.add(i);
        }
        return shapes;
    }

    public ArrayList<Integer> getAllComponents() {
        ArrayList<Integer> components = new ArrayList<Integer>();
        for (Integer i : this.registeredParts.keySet()) {
            if (!(this.registeredParts.get(i) instanceof ISpellComponent)) continue;
            components.add(i);
        }
        return components;
    }

    public ArrayList<Integer> getAllModifiers() {
        ArrayList<Integer> modifiers = new ArrayList<Integer>();
        for (Integer i : this.registeredParts.keySet()) {
            if (!(this.registeredParts.get(i) instanceof ISpellModifier)) continue;
            modifiers.add(i);
        }
        return modifiers;
    }

    public ArrayList<Integer> getAllTalents() {
        ArrayList<Integer> modifiers = new ArrayList<Integer>();
        for (Integer i : this.registeredParts.keySet()) {
            if (this.registeredParts.get(i) instanceof ISpellShape || this.registeredParts.get(i) instanceof ISpellComponent || this.registeredParts.get(i) instanceof ISpellModifier) continue;
            modifiers.add(i);
        }
        return modifiers;
    }

    public Set<String> getAllSkillNames() {
        return this.registeredPartNames.keySet();
    }

    @Override
    public int registerSkillTreeEntry(ISkillTreeEntry part, String name) {
        int id = part.getID();
        if (part instanceof ISpellComponent) {
            id += 1000;
        } else if (part instanceof ISpellModifier) {
            id += 5000;
        } else if (!(part instanceof ISpellShape)) {
            id += 6000;
        }
        if (this.registeredParts.containsKey(id)) {
            String existing = this.reversedPartNames.get(id);
            FMLLog.info((String)"Ars Magica >> Attempted to register duplicate spell part name, %s (which would overwrite %s).  The part was NOT registered.", (Object[])new Object[]{name, existing});
            return -1;
        }
        this.registeredParts.put(id, part);
        this.registeredPartNames.put(name, id);
        this.reversedPartNames.put(id, name);
        if (part instanceof ISpellPart) {
            SpellRecipeManager.instance.RegisterRecipe((ISpellPart)part);
        }
        return id;
    }

    @Override
    public ISkillTreeEntry getSkill(int id) {
        ISkillTreeEntry component = this.registeredParts.get(id);
        if (component == null) {
            return this.missingComponent;
        }
        return component;
    }

    public ISpellModifier getModifier(int id) {
        ISkillTreeEntry mod = this.registeredParts.get(id);
        if (mod == null || !(mod instanceof ISpellModifier)) {
            return this.missingModifier;
        }
        return (ISpellModifier)mod;
    }

    public ISpellShape getShape(int id) {
        ISkillTreeEntry mod = this.registeredParts.get(id);
        if (mod == null || !(mod instanceof ISpellShape)) {
            return this.missingShape;
        }
        return (ISpellShape)mod;
    }

    public ISpellComponent getComponent(int id) {
        ISkillTreeEntry mod = this.registeredParts.get(id);
        if (mod == null || !(mod instanceof ISpellComponent)) {
            return this.missingComponent;
        }
        return (ISpellComponent)mod;
    }

    @Override
    public ISkillTreeEntry getSkill(String name) {
        Integer ID = this.registeredPartNames.get(name);
        if (ID == null) {
            return null;
        }
        return this.registeredParts.get(ID);
    }

    public String getSkillName(ISkillTreeEntry component) {
        int id = component.getID();
        if (component instanceof ISpellComponent) {
            id += 1000;
        } else if (component instanceof ISpellModifier) {
            id += 5000;
        } else if (!(component instanceof ISpellShape)) {
            id += 6000;
        }
        return this.reversedPartNames.get(id);
    }

    public int getSpellPartID(Class clazz) {
        for (Integer id : this.registeredParts.keySet()) {
            ISkillTreeEntry entry = this.registeredParts.get(id);
            if (!clazz.isAssignableFrom(entry.getClass())) continue;
            return id;
        }
        FMLLog.info((String)"Ars Magica >> Spell Part not found!", (Object[])new Object[0]);
        return -1;
    }

    public int getShiftedPartID(ISkillTreeEntry part) {
        if (part instanceof ISpellShape) {
            return part.getID();
        }
        if (part instanceof ISpellComponent) {
            return part.getID() + 1000;
        }
        if (part instanceof ISpellModifier) {
            return part.getID() + 5000;
        }
        return part.getID() + 6000;
    }

    public void init() {
        this.registerSkillTreeEntry(new AoE(), "AoE");
        this.registerSkillTreeEntry(new Beam(), "Beam");
        this.registerSkillTreeEntry(new Binding(), "Binding");
        this.registerSkillTreeEntry(new Chain(), "Chain");
        this.registerSkillTreeEntry(new Channel(), "Channel");
        this.registerSkillTreeEntry(new Projectile(), "Projectile");
        this.registerSkillTreeEntry(new Rune(), "Rune");
        this.registerSkillTreeEntry(new Self(), "Self");
        this.registerSkillTreeEntry(new Summon(), "Summon");
        this.registerSkillTreeEntry(new Touch(), "Touch");
        this.registerSkillTreeEntry(new Zone(), "Zone");
        this.registerSkillTreeEntry(new Contingency_Fall(), "Contingency_Fall");
        this.registerSkillTreeEntry(new Contingency_Hit(), "Contingency_Damage");
        this.registerSkillTreeEntry(new Contingency_Fire(), "Contingency_Fire");
        this.registerSkillTreeEntry(new Contingency_Health(), "Contingency_Health");
        this.registerSkillTreeEntry(new Contingency_Death(), "Contingency_Death");
        this.registerSkillTreeEntry(new Wall(), "Wall");
        this.registerSkillTreeEntry(new Wave(), "Wave");
        this.registerSkillTreeEntry(new Accelerate(), "Accelerate");
        this.registerSkillTreeEntry(new AstralDistortion(), "AstralDistortion");
        this.registerSkillTreeEntry(new Attract(), "Attract");
        this.registerSkillTreeEntry(new BanishRain(), "BanishRain");
        this.registerSkillTreeEntry(new Blind(), "Blind");
        this.registerSkillTreeEntry(new Blink(), "Blink");
        this.registerSkillTreeEntry(new ChronoAnchor(), "ChronoAnchor");
        this.registerSkillTreeEntry(new CreateWater(), "CreateWater");
        this.registerSkillTreeEntry(new Dig(), "Dig");
        this.registerSkillTreeEntry(new Disarm(), "Disarm");
        this.registerSkillTreeEntry(new Dispel(), "Dispel");
        this.registerSkillTreeEntry(new DivineIntervention(), "DivineIntervention");
        this.registerSkillTreeEntry(new Drought(), "Drought");
        this.registerSkillTreeEntry(new EnderIntervention(), "EnderIntervention");
        this.registerSkillTreeEntry(new Entangle(), "Entangle");
        this.registerSkillTreeEntry(new FireDamage(), "FireDamage");
        this.registerSkillTreeEntry(new Flight(), "Flight");
        this.registerSkillTreeEntry(new Fling(), "Fling");
        this.registerSkillTreeEntry(new Forge(), "Forge");
        this.registerSkillTreeEntry(new Freeze(), "Freeze");
        this.registerSkillTreeEntry(new FrostDamage(), "FrostDamage");
        this.registerSkillTreeEntry(new GravityWell(), "GravityWell");
        this.registerSkillTreeEntry(new Grow(), "Grow");
        this.registerSkillTreeEntry(new HarvestPlants(), "HarvestPlants");
        this.registerSkillTreeEntry(new Haste(), "Haste");
        this.registerSkillTreeEntry(new Heal(), "Heal");
        this.registerSkillTreeEntry(new Ignition(), "Ignition");
        this.registerSkillTreeEntry(new Invisiblity(), "Invisibility");
        this.registerSkillTreeEntry(new Knockback(), "Knockback");
        this.registerSkillTreeEntry(new Leap(), "Leap");
        this.registerSkillTreeEntry(new Levitation(), "Levitate");
        this.registerSkillTreeEntry(new LifeDrain(), "LifeDrain");
        this.registerSkillTreeEntry(new LifeTap(), "LifeTap");
        this.registerSkillTreeEntry(new Light(), "Light");
        this.registerSkillTreeEntry(new LightningDamage(), "LightningDamage");
        this.registerSkillTreeEntry(new MagicDamage(), "MagicDamage");
        this.registerSkillTreeEntry(new ManaDrain(), "ManaDrain");
        this.registerSkillTreeEntry(new Mark(), "Mark");
        this.registerSkillTreeEntry(new NightVision(), "NightVision");
        this.registerSkillTreeEntry(new PhysicalDamage(), "PhysicalDamage");
        this.registerSkillTreeEntry(new Plant(), "Plant");
        this.registerSkillTreeEntry(new Plow(), "Plow");
        this.registerSkillTreeEntry(new RandomTeleport(), "RandomTeleport");
        this.registerSkillTreeEntry(new Recall(), "Recall");
        this.registerSkillTreeEntry(new Reflect(), "Reflect");
        this.registerSkillTreeEntry(new Regeneration(), "Regeneration");
        this.registerSkillTreeEntry(new Repel(), "Repel");
        this.registerSkillTreeEntry(new Rift(), "Rift");
        this.registerSkillTreeEntry(new Shield(), "Shield");
        this.registerSkillTreeEntry(new Slow(), "Slow");
        this.registerSkillTreeEntry(new Slowfall(), "Slowfall");
        this.registerSkillTreeEntry(new Storm(), "Storm");
        this.registerSkillTreeEntry(new SwiftSwim(), "SwiftSwim");
        this.registerSkillTreeEntry(new Telekinesis(), "Telekinesis");
        this.registerSkillTreeEntry(new Transplace(), "Transplace");
        this.registerSkillTreeEntry(new TrueSight(), "TrueSight");
        this.registerSkillTreeEntry(new WaterBreathing(), "WaterBreathing");
        this.registerSkillTreeEntry(new WateryGrave(), "WateryGrave");
        this.registerSkillTreeEntry(new Charm(), "Charm");
        this.registerSkillTreeEntry(new MeltArmor(), "MeltArmor");
        this.registerSkillTreeEntry(new Drown(), "Drown");
        this.registerSkillTreeEntry(new Blizzard(), "Blizzard");
        this.registerSkillTreeEntry(new Daylight(), "Daylight");
        this.registerSkillTreeEntry(new FallingStar(), "FallingStar");
        this.registerSkillTreeEntry(new FireRain(), "FireRain");
        this.registerSkillTreeEntry(new ManaLink(), "ManaLink");
        this.registerSkillTreeEntry(new ManaShield(), "ManaShield");
        this.registerSkillTreeEntry(new Moonrise(), "Moonrise");
        this.registerSkillTreeEntry(new WizardsAutumn(), "WizardsAutumn");
        this.registerSkillTreeEntry(new Appropriation(), "Appropriation");
        this.registerSkillTreeEntry(new Fury(), "Fury");
        this.registerSkillTreeEntry(new Silence(), "Silence");
        this.registerSkillTreeEntry(new ScrambleSynapses(), "ScrambleSynapses");
        this.registerSkillTreeEntry(new PlaceBlock(), "PlaceBlock");
        this.registerSkillTreeEntry(new Shrink(), "Shrink");
        this.registerSkillTreeEntry(new Nauseate(), "Nauseate");
        this.registerSkillTreeEntry(new Bounce(), "Bounce");
        this.registerSkillTreeEntry(new Speed(), "Speed");
        this.registerSkillTreeEntry(new Gravity(), "Gravity");
        this.registerSkillTreeEntry(new Damage(), "Damage");
        this.registerSkillTreeEntry(new Healing(), "Healing");
        this.registerSkillTreeEntry(new VelocityAdded(), "VelocityAdded");
        this.registerSkillTreeEntry(new Radius(), "Radius");
        this.registerSkillTreeEntry(new Duration(), "Duration");
        this.registerSkillTreeEntry(new RuneProcs(), "RuneProcs");
        this.registerSkillTreeEntry(new Range(), "Range");
        this.registerSkillTreeEntry(new Lunar(), "Lunar");
        this.registerSkillTreeEntry(new TargetNonSolidBlocks(), "TargetNonSolid");
        this.registerSkillTreeEntry(new Solar(), "Solar");
        this.registerSkillTreeEntry(new Piercing(), "Piercing");
        this.registerSkillTreeEntry(new Colour(), "Colour");
        this.registerSkillTreeEntry(new MiningPower(), "MiningPower");
        this.registerSkillTreeEntry(new Prosperity(), "Prosperity");
        this.registerSkillTreeEntry(new BuffPower(), "BuffPower");
        this.registerSkillTreeEntry(new Dismembering(), "Dismembering");
        this.registerSkillTreeEntry(new FeatherTouch(), "FeatherTouch");
        this.registerSkillTreeEntry(new AffinityGainsBoost(), "AffinityGains");
        this.registerSkillTreeEntry(new AugmentedCasting(), "AugmentedCasting");
        this.registerSkillTreeEntry(new ExtraSummon(), "ExtraSummon");
        this.registerSkillTreeEntry(new MagePosseI(), "MageBandI");
        this.registerSkillTreeEntry(new MagePosseII(), "MageBandII");
        this.registerSkillTreeEntry(new ManaRegenBoostI(), "ManaRegenI");
        this.registerSkillTreeEntry(new ManaRegenBoostII(), "ManaRegenII");
        this.registerSkillTreeEntry(new ManaRegenBoostIII(), "ManaRegenIII");
        this.registerSkillTreeEntry(new SpellMovement(), "SpellMotion");
    }

    public String getDisplayName(ISkillTreeEntry part) {
        return StatCollector.func_74838_a((String)String.format("am2.spell.%s", this.getSkillName(part).toLowerCase()));
    }

    public String getDisplayName(String unlocalizedName) {
        return StatCollector.func_74838_a((String)String.format("am2.spell.%s", unlocalizedName.toLowerCase()));
    }

    public class CaseInsensitiveMap<K extends String, V>
    extends HashMap<K, V> {
        @Override
        public V put(K key, V value) {
            return super.put(((String)key).toLowerCase(), value);
        }

        public V get(String key) {
            return super.get(key.toLowerCase());
        }
    }
}

