/*
 * Decompiled with CFR 0.152.
 */
package am2.armor;

import am2.AMCore;
import am2.api.items.armor.IArmorImbuement;
import am2.api.items.armor.ImbuementTiers;
import am2.armor.AMArmor;
import am2.armor.infusions.ImbuementRegistry;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.utility.EntityUtilities;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ArmorHelper {
    private static final HashMap<String, Integer> armorRenderPrefixes = new HashMap();
    private static final int IMBUE_TIER_COST = 12;

    public static int getArmorRenderIndex(String armorName) {
        if (armorRenderPrefixes.containsKey(armorName)) {
            return armorRenderPrefixes.get(armorName);
        }
        int newPrefix = AMCore.proxy.getArmorRenderIndex(armorName);
        armorRenderPrefixes.put(armorName, newPrefix);
        return newPrefix;
    }

    public static boolean PlayerHasArmorInSlot(EntityPlayer player, int armorSlot) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        return armor[armorSlot] != null;
    }

    public static void HandleArmorInfusion(EntityPlayer player) {
        ExtendedProperties extendedProperties = ExtendedProperties.For((EntityLivingBase)player);
        float infusionCost = 0.0f;
        boolean bFullSet = ArmorHelper.getFullArsMagicaArmorSet(player) != -1;
        for (int i = 0; i < 4; ++i) {
            infusionCost += ArmorHelper.GetArsMagicaArmorInfusionCostFromSlot(player, i);
        }
        if (bFullSet) {
            infusionCost = (float)((double)infusionCost * 0.75);
        }
        if (infusionCost > 0.0f && extendedProperties.getCurrentMana() > infusionCost) {
            int repairAmount;
            extendedProperties.setCurrentMana(extendedProperties.getCurrentMana() - infusionCost);
            extendedProperties.bankedInfusionHelm += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, 3);
            extendedProperties.bankedInfusionChest += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, 2);
            extendedProperties.bankedInfusionLegs += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, 1);
            extendedProperties.bankedInfusionBoots += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, 0);
            if (extendedProperties.bankedInfusionHelm > 1.0f) {
                repairAmount = (int)Math.floor(extendedProperties.bankedInfusionHelm);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, 3);
                extendedProperties.bankedInfusionHelm -= (float)repairAmount;
            }
            if (extendedProperties.bankedInfusionChest > 1.0f) {
                repairAmount = (int)Math.floor(extendedProperties.bankedInfusionChest);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, 2);
                extendedProperties.bankedInfusionChest -= (float)repairAmount;
            }
            if (extendedProperties.bankedInfusionLegs > 1.0f) {
                repairAmount = (int)Math.floor(extendedProperties.bankedInfusionLegs);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, 1);
                extendedProperties.bankedInfusionLegs -= (float)repairAmount;
            }
            if (extendedProperties.bankedInfusionBoots > 1.0f) {
                repairAmount = (int)Math.floor(extendedProperties.bankedInfusionBoots);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, 0);
                extendedProperties.bankedInfusionBoots -= (float)repairAmount;
            }
        }
    }

    private static void RepairEquippedArsMagicaArmorItem(EntityPlayer player, int repairAmount, int slot) {
        if (!ArmorHelper.PlayerHasArmorInSlot(player, slot)) {
            return;
        }
        ItemStack armor = player.field_71071_by.field_70460_b[slot];
        if (armor.func_77951_h()) {
            armor.func_77972_a(-repairAmount, (EntityLivingBase)player);
        }
    }

    private static float GetArsMagicaArmorRepairAmountFromSlot(EntityPlayer player, int armorSlot) {
        if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, armorSlot)) {
            return 0.0f;
        }
        if (player.field_71071_by.field_70460_b[armorSlot].func_77951_h()) {
            AMArmor armor = (AMArmor)player.field_71071_by.field_70460_b[armorSlot].func_77973_b();
            return armor.GetInfusionRepair();
        }
        return 0.0f;
    }

    private static boolean PlayerHasArsInfusableInSlot(EntityPlayer player, int armorSlot) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        return armor[armorSlot] != null && armor[armorSlot].func_77973_b() instanceof AMArmor;
    }

    private static float GetArsMagicaArmorInfusionCostFromSlot(EntityPlayer player, int armorSlot) {
        if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, armorSlot)) {
            return 0.0f;
        }
        if (player.field_71071_by.field_70460_b[armorSlot].func_77951_h()) {
            AMArmor armor = (AMArmor)player.field_71071_by.field_70460_b[armorSlot].func_77973_b();
            return armor.GetInfusionCost();
        }
        return 0.0f;
    }

    public static int getFullArsMagicaArmorSet(EntityPlayer player) {
        int matlID = -1;
        for (int i = 0; i < 4; ++i) {
            if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, i)) {
                return -1;
            }
            AMArmor armor = (AMArmor)player.field_71071_by.field_70460_b[i].func_77973_b();
            if (matlID == -1) {
                matlID = armor.getMaterialID();
                continue;
            }
            if (matlID == armor.getMaterialID()) continue;
            return -1;
        }
        return matlID;
    }

    public static void HandleArmorEffects(EntityPlayer player, World world) {
        if (world.field_72995_K) {
            return;
        }
        ExtendedProperties extendedProperties = ExtendedProperties.For((EntityLivingBase)player);
        for (int i = 0; i < extendedProperties.armorProcCooldowns.length; ++i) {
            if (extendedProperties.armorProcCooldowns[i] <= 0) continue;
            int n = i;
            extendedProperties.armorProcCooldowns[n] = extendedProperties.armorProcCooldowns[n] - 1;
        }
    }

    private static ItemStack GetAMProtectiveArmorInSlot(EntityPlayer player, int armorSlot) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        if (armor[armorSlot] != null) {
            for (Item i : ItemsCommonProxy.protectiveArmors) {
                if (armor[armorSlot].func_77973_b() != i) continue;
                return armor[armorSlot];
            }
        }
        return null;
    }

    public static IArmorImbuement[] getInfusionsOnArmor(EntityPlayer player, int armorSlot) {
        ItemStack stack = player.func_82169_q(armorSlot);
        return ArmorHelper.getInfusionsOnArmor(stack);
    }

    public static IArmorImbuement[] getInfusionsOnArmor(ItemStack stack) {
        String infusionList;
        if (stack == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof ItemArmor)) {
            return new IArmorImbuement[0];
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.field_77990_d.func_74781_a("AMArmorProperties");
        if (armorProps != null && (infusionList = armorProps.func_74779_i("armorEffects")) != null && infusionList != "") {
            String[] ids = infusionList.split("\\|");
            IArmorImbuement[] infusions = new IArmorImbuement[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                infusions[i] = ImbuementRegistry.instance.getImbuementByID(ids[i]);
            }
            return infusions;
        }
        return new IArmorImbuement[0];
    }

    public static boolean isInfusionPreset(ItemStack stack, String id) {
        String infusionList;
        if (stack == null || !stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.field_77990_d.func_74781_a("AMArmorProperties");
        if (armorProps != null && (infusionList = armorProps.func_74779_i("armorEffects")) != null) {
            return infusionList.contains(id);
        }
        return false;
    }

    public static void imbueArmor(ItemStack armorStack, String id, boolean ignoreLevelRequirement) {
        IArmorImbuement imbuement = ImbuementRegistry.instance.getImbuementByID(id);
        if (armorStack != null && imbuement != null && armorStack.func_77973_b() instanceof ItemArmor) {
            if (!ignoreLevelRequirement && ArmorHelper.getArmorLevel(armorStack) < ArmorHelper.getImbueCost(imbuement.getTier())) {
                return;
            }
            for (int i : imbuement.getValidSlots()) {
                String infusionList;
                NBTTagCompound armorProps;
                if (i != ((ItemArmor)armorStack.func_77973_b()).field_77881_a) continue;
                if (!armorStack.func_77942_o()) {
                    armorStack.func_77982_d(new NBTTagCompound());
                }
                if ((armorProps = (NBTTagCompound)armorStack.field_77990_d.func_74781_a("AMArmorProperties")) == null) {
                    armorProps = new NBTTagCompound();
                }
                infusionList = (infusionList = armorProps.func_74779_i("armorEffects")) == null || infusionList == "" ? id : infusionList + "|" + id;
                armorProps.func_74778_a("armorEffects", infusionList);
                armorStack.field_77990_d.func_74782_a("AMArmorProperties", (NBTBase)armorProps);
                ArmorHelper.deductXPFromArmor(EntityUtilities.getXPFromLevel(ArmorHelper.getImbueCost(imbuement.getTier())), armorStack);
                break;
            }
        }
    }

    public static int getArmorLevel(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.field_77990_d.func_74781_a("AMArmorProperties");
        if (armorProps != null) {
            return armorProps.func_74762_e("XPLevel");
        }
        return 0;
    }

    public static int getImbueCost(ImbuementTiers tier) {
        return 30 + tier.ordinal() * 12;
    }

    public static void addXPToArmor(float totalAmt, EntityPlayer player) {
        int numPieces = 0;
        for (int i = 0; i < 4; ++i) {
            if (player.func_82169_q(i) == null) continue;
            ++numPieces;
        }
        float xpPerPiece = totalAmt / (float)numPieces;
        for (int i = 0; i < 4; ++i) {
            ArmorHelper.addXPToArmor(xpPerPiece, player.func_82169_q(i));
        }
    }

    public static void deductXPFromArmor(float amt, ItemStack armor) {
        if (armor != null && armor.func_77973_b() instanceof ItemArmor) {
            NBTTagCompound armorProps;
            if (!armor.func_77942_o()) {
                armor.func_77982_d(new NBTTagCompound());
            }
            if ((armorProps = (NBTTagCompound)armor.field_77990_d.func_74781_a("AMArmorProperties")) == null) {
                armorProps = new NBTTagCompound();
            }
            armorProps.func_74780_a("infusedXP", Math.max(armorProps.func_74769_h("infusedXP") - (double)amt, 0.0));
            armorProps.func_74768_a("XPLevel", EntityUtilities.getLevelFromXP((float)armorProps.func_74769_h("infusedXP")));
            armor.field_77990_d.func_74782_a("AMArmorProperties", (NBTBase)armorProps);
        }
    }

    public static void addXPToArmor(float amt, ItemStack armor) {
        if (armor != null && armor.func_77973_b() instanceof ItemArmor) {
            NBTTagCompound armorProps;
            if (!armor.func_77942_o()) {
                armor.func_77982_d(new NBTTagCompound());
            }
            if ((armorProps = (NBTTagCompound)armor.field_77990_d.func_74781_a("AMArmorProperties")) == null) {
                armorProps = new NBTTagCompound();
            }
            armorProps.func_74780_a("infusedXP", armorProps.func_74769_h("infusedXP") + (double)amt);
            armorProps.func_74768_a("XPLevel", EntityUtilities.getLevelFromXP((float)armorProps.func_74769_h("infusedXP")));
            armor.field_77990_d.func_74782_a("AMArmorProperties", (NBTBase)armorProps);
        }
    }
}

