/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.GregsLighting;
import gcewing.lighting.TEFloodlightBeam;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Floodlight {
    public static int maxRange = 64;
    public static int maxLightChangesPerStep = 1;
    public static boolean debugBeamBlocks = false;
    public static boolean debugBeamBlockPlacement = false;
    public static boolean debugScheduledUpdates = false;
    static List<ScheduledBeamUpdate> scheduledBeamUpdates;

    public static void configure(BaseConfiguration baseConfiguration) {
        maxRange = baseConfiguration.getInteger("options", "maxFloodlightRange", maxRange);
        maxLightChangesPerStep = baseConfiguration.getInteger("options", "maxLightChangesPerTick", maxLightChangesPerStep);
        debugBeamBlocks = baseConfiguration.getBoolean("options", "debugBeamBlocks", false);
        debugScheduledUpdates = baseConfiguration.getBoolean("options", "debugScheduledUpdates", false);
    }

    public static void updateBeams(World world, int n, int n2, int n3) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.updateBeams at (%d,%d,%d)\n", n, n2, n3);
        }
        for (int i = 0; i < 6; ++i) {
            Floodlight.updateBeamInDirection(world, n, n2, n3, ForgeDirection.getOrientation((int)i));
        }
    }

    public static void updateBeamInDirection(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (debugBeamBlocks || debugScheduledUpdates) {
            System.out.printf("Floodlight.updateBeamInDirection %s from (%d,%d,%d) in %s\n", forgeDirection, n, n2, n3, world);
        }
        int n4 = Floodlight.findSourceIntensity(world, n, n2, n3, forgeDirection);
        Floodlight.propagateBeam(world, n, n2, n3, forgeDirection, n4);
    }

    static int findSourceIntensity(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.findSourceIntensity %s from (%d,%d,%d)\n", forgeDirection, n, n2, n3);
        }
        int n4 = world.func_72800_K();
        for (int i = 1; i <= maxRange; ++i) {
            int n5;
            int n6 = n - i * forgeDirection.offsetX;
            int n7 = n2 - i * forgeDirection.offsetY;
            int n8 = n3 - i * forgeDirection.offsetZ;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Checking (%d,%d,%d)\n", n6, n7, n8);
            }
            if (n7 < 0 || n7 >= n4) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Reached edge of map, returning 0\n", new Object[0]);
                }
                return 0;
            }
            Block block = Floodlight.getBlock(world, n6, n7, n8);
            if (block == null) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found air, returning 0\n", new Object[0]);
                }
                return 0;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found %s\n", block.func_149732_F());
            }
            if (block instanceof BlockFloodlight) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found floodlight\n", new Object[0]);
                }
                if (((BlockFloodlight)block).isActiveInDirection(world, n6, n7, n8, forgeDirection)) {
                    n5 = maxRange + 1 - i;
                    if (debugBeamBlocks) {
                        System.out.printf("Floodlight.findSourceIntensity: Is active, returning %d\n", n5);
                    }
                    return n5;
                }
            }
            if (block instanceof BlockFloodlightBeam && (n5 = Floodlight.beamIntensity(world, n6, n7, n8, forgeDirection)) > 0) {
                int n9 = n5 - i;
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found beam block, returning %d\n", n9);
                }
                return n9;
            }
            if (!block.func_149662_c()) continue;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found opaque block, returning 0\n", new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static void propagateBeam(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.propagateBeam %s from (%d,%d,%d) with intensity %d\n", forgeDirection, n, n2, n3, n4);
        }
        int n5 = world.func_72800_K();
        int n6 = 0;
        int n7 = 0;
        while (n6 < maxRange) {
            int n8 = n + n6 * forgeDirection.offsetX;
            int n9 = n2 + n6 * forgeDirection.offsetY;
            int n10 = n3 + n6 * forgeDirection.offsetZ;
            if (n7 >= maxLightChangesPerStep) {
                Floodlight.scheduleBeamUpdate(world, n8, n9, n10, forgeDirection);
                return;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.propagateBeam: Checking (%d,%d,%d)\n", n8, n9, n10);
            }
            if (n9 < 0 || n9 >= n5) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Reached edge of map\n", new Object[0]);
                }
                return;
            }
            Block block = Floodlight.getBlock(world, n8, n9, n10);
            if (block.func_149662_c()) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Found opaque block\n", new Object[0]);
                }
                return;
            }
            if (block == Blocks.field_150350_a || block instanceof BlockFloodlightBeam) {
                switch (Floodlight.setBeamIntensity(world, n8, n9, n10, forgeDirection, n4)) {
                    case NoChange: {
                        if (debugBeamBlocks) {
                            System.out.printf("Floodlight.propagateBeam: Intensity already correct\n", new Object[0]);
                        }
                        return;
                    }
                    case LightChanged: {
                        ++n7;
                    }
                }
            }
            ++n6;
            --n4;
        }
    }

    static Block getBlock(World world, int n, int n2, int n3) {
        return world.func_147439_a(n, n2, n3);
    }

    static int beamIntensity(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TEFloodlightBeam tEFloodlightBeam = Floodlight.getBeamTileEntity(world, n, n2, n3);
        if (tEFloodlightBeam != null) {
            return tEFloodlightBeam.getIntensity(forgeDirection);
        }
        return 0;
    }

    static BeamBlockChange setBeamIntensity(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TEFloodlightBeam tEFloodlightBeam;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (n4 < 0) {
            n4 = 0;
        }
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.setBeamIntensity %s at (%d,%d,%d) to %d\n", forgeDirection, n, n2, n3, n4);
        }
        if ((object = Floodlight.getBlock(world, n, n2, n3)) == Blocks.field_150350_a) {
            if (n4 == 0) {
                return BeamBlockChange.NoChange;
            }
            if (debugBeamBlocks || debugBeamBlockPlacement) {
                System.out.printf("Floodlight.setBeamIntensity: Placing beam block at (%d,%d,%d)\n", n, n2, n3);
            }
            object = GregsLighting.floodlightBeam;
            world.func_147465_d(n, n2, n3, object, 0, 2);
            bl = true;
        }
        if ((tEFloodlightBeam = Floodlight.getBeamTileEntity(world, n, n2, n3)) != null) {
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Intensities before = %d, %d, %d, %d, %d, %d\n", tEFloodlightBeam.intensity[0], tEFloodlightBeam.intensity[1], tEFloodlightBeam.intensity[2], tEFloodlightBeam.intensity[3], tEFloodlightBeam.intensity[4], tEFloodlightBeam.intensity[5]);
            }
            if (tEFloodlightBeam.setIntensity(forgeDirection, n4)) {
                bl2 = true;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Intensities after = %d, %d, %d, %d, %d, %d\n", tEFloodlightBeam.intensity[0], tEFloodlightBeam.intensity[1], tEFloodlightBeam.intensity[2], tEFloodlightBeam.intensity[3], tEFloodlightBeam.intensity[4], tEFloodlightBeam.intensity[5]);
            }
            if (tEFloodlightBeam.allIntensitiesZero()) {
                if (debugBeamBlocks || debugBeamBlockPlacement) {
                    System.out.printf("Floodlight.setBeamIntensity: Removing beam block at (%d,%d,%d)\n", n, n2, n3);
                }
                world.func_147465_d(n, n2, n3, Blocks.field_150350_a, 0, 2);
                bl = true;
            }
        }
        if (bl) {
            return BeamBlockChange.LightChanged;
        }
        if (bl2) {
            return BeamBlockChange.IntensityChanged;
        }
        return BeamBlockChange.NoChange;
    }

    static TEFloodlightBeam getBeamTileEntity(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TEFloodlightBeam) {
            return (TEFloodlightBeam)tileEntity;
        }
        return null;
    }

    static void scheduleBeamUpdate(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (debugScheduledUpdates) {
            System.out.printf("Floodlight.scheduleBeamUpdate %s from (%d,%d,%d) in %s\n", forgeDirection, n, n2, n3, world);
        }
        if (scheduledBeamUpdates == null) {
            scheduledBeamUpdates = new ArrayList<ScheduledBeamUpdate>();
        }
        ScheduledBeamUpdate scheduledBeamUpdate = new ScheduledBeamUpdate();
        scheduledBeamUpdate.world = world;
        scheduledBeamUpdate.x = n;
        scheduledBeamUpdate.y = n2;
        scheduledBeamUpdate.z = n3;
        scheduledBeamUpdate.dir = forgeDirection;
        scheduledBeamUpdates.add(scheduledBeamUpdate);
    }

    public static void performScheduledBeamUpdates() {
        if (scheduledBeamUpdates != null) {
            List<ScheduledBeamUpdate> list = scheduledBeamUpdates;
            scheduledBeamUpdates = null;
            for (ScheduledBeamUpdate scheduledBeamUpdate : list) {
                Floodlight.updateBeamInDirection(scheduledBeamUpdate.world, scheduledBeamUpdate.x, scheduledBeamUpdate.y, scheduledBeamUpdate.z, scheduledBeamUpdate.dir);
            }
        }
    }

    static class ScheduledBeamUpdate {
        World world;
        int x;
        int y;
        int z;
        ForgeDirection dir;

        ScheduledBeamUpdate() {
        }
    }

    static enum BeamBlockChange {
        NoChange,
        IntensityChanged,
        LightChanged;

    }
}

