/*
 * Decompiled with CFR 0.152.
 */
package extracells.definitions;

import appeng.api.definitions.ITileDefinition;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BlockItemDefinitions
implements ITileDefinition {
    private final Block block;
    private final int meta;
    private final Class<? extends TileEntity> blockTileEntity;

    public BlockItemDefinitions(Block _block) {
        this(_block, 0);
    }

    public BlockItemDefinitions(Block _block, Class<? extends TileEntity> _blockTileEntity) {
        this(_block, 0, _blockTileEntity);
    }

    public BlockItemDefinitions(Block _block, int _meta) {
        this(_block, _meta, null);
    }

    public BlockItemDefinitions(Block _block, int _meta, Class<? extends TileEntity> _blockTileEntity) {
        this.block = _block;
        this.meta = _meta;
        this.blockTileEntity = _blockTileEntity;
    }

    public Optional<Block> maybeBlock() {
        return Optional.fromNullable((Object)this.block);
    }

    public Optional<ItemBlock> maybeItemBlock() {
        return Optional.absent();
    }

    public boolean isSameAs(ItemStack comparableStack) {
        return comparableStack != null && ItemStack.func_77989_b((ItemStack)((ItemStack)this.maybeStack(1).orNull()), (ItemStack)comparableStack);
    }

    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return !this.maybeBlock().isPresent() && block == this.block;
    }

    public Optional<Item> maybeItem() {
        return Optional.fromNullable((Object)Item.func_150898_a((Block)this.block));
    }

    public Optional<ItemStack> maybeStack(int stackSize) {
        return Optional.of((Object)new ItemStack(this.block, stackSize, this.meta));
    }

    public Optional<? extends Class<? extends TileEntity>> maybeEntity() {
        return Optional.fromNullable(this.blockTileEntity);
    }
}

