/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.security;

import com.austinv11.collectiveframework.utils.security.SecretValue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class Encryption {
    private static final boolean useSunApi = Encryption.isSunPackageAvailable();
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static SecretValue<String, byte[], Integer> encrypt(String string, String algorithm, byte[] key, byte[] initializationVector) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] data = string.getBytes();
        SecretKeySpec keySpec = algorithm.contains("/") ? new SecretKeySpec(key, algorithm.split("/")[0]) : new SecretKeySpec(key, algorithm);
        IvParameterSpec ivSpec = new IvParameterSpec(initializationVector);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)keySpec, ivSpec);
        byte[] encrypted = new byte[cipher.getOutputSize(data.length)];
        int encryptionLength = cipher.update(data, 0, data.length, encrypted, 0);
        encryptionLength += cipher.doFinal(encrypted, encryptionLength);
        return Encryption.newSecretValue(new String(encrypted), key, encryptionLength);
    }

    public static SecretValue<String, byte[], Integer> decrypt(String string, int encryptionLength, String algorithm, byte[] key, byte[] initializationVector) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] data = string.getBytes();
        SecretKeySpec keySpec = algorithm.contains("/") ? new SecretKeySpec(key, algorithm.split("/")[0]) : new SecretKeySpec(key, algorithm);
        IvParameterSpec ivSpec = new IvParameterSpec(initializationVector);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)keySpec, ivSpec);
        byte[] decrypted = new byte[cipher.getOutputSize(encryptionLength)];
        int decryptionLength = cipher.update(data, 0, encryptionLength, decrypted, 0);
        decryptionLength += cipher.doFinal(decrypted, decryptionLength);
        return Encryption.newSecretValue(new String(decrypted), key, decryptionLength);
    }

    public static <V, K, M> SecretValue<V, K, M> newSecretValue(V value, K key, M meta, boolean isCallerSensitive, String approvedCaller) {
        return new SecretValue<V, K, M>(value, key, meta, isCallerSensitive, approvedCaller);
    }

    @CallerSensitive
    public static <V, K, M> SecretValue<V, K, M> newSecretValue(V value, K key, M meta, boolean isCallerSensitive) {
        if (useSunApi && isCallerSensitive) {
            return Encryption.newSecretValue(value, key, meta, isCallerSensitive, Reflection.getCallerClass().getName());
        }
        return Encryption.newSecretValue(value, key, meta);
    }

    public static <V, K, M> SecretValue<V, K, M> newSecretValue(V value, K key, M meta) {
        return new SecretValue<V, K, M>(value, key, meta);
    }

    @CallerSensitive
    public static <V, K, M> V getValue(SecretValue<V, K, M> value) {
        if (useSunApi && value.isCallerSensitive && !Reflection.getCallerClass().getName().equals(value.approvedCaller)) {
            throw new SecurityException("Unapproved caller!");
        }
        return value.value;
    }

    @CallerSensitive
    public static <V, K, M> K getKey(SecretValue<V, K, M> value) {
        if (useSunApi && value.isCallerSensitive && !Reflection.getCallerClass().getName().equals(value.approvedCaller)) {
            throw new SecurityException("Unapproved caller!");
        }
        return value.key;
    }

    @CallerSensitive
    public static <V, K, M> M getMeta(SecretValue<V, K, M> value) {
        if (useSunApi && value.isCallerSensitive && !Reflection.getCallerClass().getName().equals(value.approvedCaller)) {
            throw new SecurityException("Unapproved caller!");
        }
        return value.meta;
    }

    public static String base64Encode(String string, String encoding) throws UnsupportedOperationException, UnsupportedEncodingException {
        if (!useSunApi) {
            throw new UnsupportedOperationException("Sun Package not found!");
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(string.getBytes(encoding));
    }

    public static String base64Encode(String string) throws UnsupportedOperationException, UnsupportedEncodingException {
        return Encryption.base64Encode(string, DEFAULT_ENCODING);
    }

    public static String base64Decode(String string, String encoding) throws UnsupportedOperationException, IOException {
        if (!useSunApi) {
            throw new UnsupportedOperationException("Sun Package not found!");
        }
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(string), encoding);
    }

    public static String base64Decode(String string) throws UnsupportedOperationException, IOException {
        return Encryption.base64Decode(string, DEFAULT_ENCODING);
    }

    private static boolean isSunPackageAvailable() {
        try {
            Class.forName("sun.misc.BASE64Encoder");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final class EncryptionType {
        public static final String AES = "AES";
        public static final String AES_WRAP = "AESWrap";
        public static final String ARCFOUR = "ARCFOUR";
        public static final String BLOWFISH = "Blowfish";
        public static final String CCM = "CCM";
        public static final String DES = "DES";
        public static final String DE_SEDE = "DESede";
        public static final String DE_SEDE_WRAP = "DESedeWrap";
        public static final String ECIES = "ECIES";
        public static final String GCM = "GCM";
        public static final String RC2 = "RC2";
        public static final String RC4 = "RC4";
        public static final String RC5 = "RC5";
        public static final String RSA = "RSA";
        public static final String NONE = "NONE";
        public static final String CBC = "CBC";
        public static final String CFB = "CFB";
        public static final String CTR = "CTR";
        public static final String CTS = "CTS";
        public static final String ECB = "ECB";
        public static final String OFB = "OFB";
        public static final String PCBC = "PCBC";
        public static final String NO_PADDING = "NoPadding";
        public static final String ISO10126_PADDING = "ISO10126Padding";
        public static final String OAEP_PADDING = "OAEPPadding";
        public static final String PKCS1_PADDING = "PKCS1Padding";
        public static final String PKCS5_PADDING = "PKCS5Padding";
        public static final String SSL3_PADDING = "SSL3Padding";
        private final String type;

        public EncryptionType(String algorithm) {
            this.type = algorithm;
        }

        public EncryptionType(String algorithm, String mode, String padding) {
            this.type = algorithm + "/" + mode + "/" + padding;
        }

        public String toString() {
            return this.type;
        }
    }
}

