/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math;

import com.austinv11.collectiveframework.utils.math.MathUtils;

public class Ratio {
    private double[] originalValues;
    private double[] reducedValues;
    private double lcd;

    public Ratio(double ... values) {
        double lcd;
        this.originalValues = values;
        this.reducedValues = new double[values.length];
        this.lcd = lcd = MathUtils.findLowestCommonDenominator(values);
        if (Double.isNaN(lcd)) {
            this.reducedValues = this.originalValues;
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.reducedValues[i] = values[i] / lcd;
            }
        }
    }

    public double[] getOriginalRatio() {
        return this.originalValues;
    }

    public double[] getReducedRatio() {
        return this.reducedValues;
    }

    public double getLCD() {
        return this.lcd;
    }
}

