/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math;

public class MathUtils {
    public static int MAX_PASSES = 1024;

    public static boolean isWholeNumber(Number number) {
        return (long)number.intValue() == number.longValue();
    }

    public static double getMin(double ... numbers) {
        double min = numbers[0];
        for (double n : numbers) {
            if (!(n < min)) continue;
            min = n;
        }
        return min;
    }

    public static double getMax(double ... numbers) {
        double max = numbers[0];
        for (double n : numbers) {
            if (!(n > max)) continue;
            max = n;
        }
        return max;
    }

    public static boolean isBetween(double min, double max, double value, boolean inclusive) {
        if (inclusive) {
            return value <= max && value >= min;
        }
        return value < max && value > min;
    }

    public static boolean isStringNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEvenNumber(int number) {
        return number % 2 == 0;
    }

    public static double findLowestCommonDenominator(double ... values) {
        block0: for (int i = 2; i < MAX_PASSES + 2; ++i) {
            for (double value : values) {
                if (value % (double)i != 0.0) continue block0;
            }
            return i;
        }
        return Double.NaN;
    }
}

